# Wan2.1-14B-480P-INT8-Lightx2v

## 项目简介

基于 Lightx2v 组件实现 Wan2.1-14B-480P-INT8 模型推理部署

---

## 环境部署

### 1. 拉取镜像

```bash
docker pull harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226
```

### 2. 创建容器

```bash
docker run -dit \
  --name Wan2_1_Lightx2v \
  --network=host \
  --ipc=host \
  --shm-size=256G \
  --group-add video \
  --cap-add=SYS_PTRACE \
  --device /dev/kfd \
  --device /dev/dri \
  -v /opt/hyhal:/opt/hyhal:ro \
  -v $(pwd):/workspace \
  -w /workspace \
  --privileged \
  -u root \
  --ulimit stack=-1:-1 \
  --ulimit memlock=-1:-1 \
  --security-opt seccomp=unconfined \
  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226 \
  /bin/bash
```

进入容器
```bash
docker exec -it Wan2_1_Lightx2v bash
```

---

## 测试步骤

### 1. 拉取代码&安装

```bash
git clone http://developer.sourcefind.cn/codes/bw-bestperf/wan2.1-14b-480p-int8-lightx2v.git
cd wan2.1-14b-480p-int8-lightx2v
pip install -v . -i https://pypi.tuna.tsinghua.edu.cn/simple
pip install numpy==1.25.0
```

### 2. 获取&安装定制依赖

```bash
# flash_attn
curl -f -C - -o flash_attn-2.6.1+das.opt1.dtk25044-cp310-cp310-manylinux_2_28_x86_64.whl https://ksefile.hpccube.com:65241/efile/s/d/bGl0emg=/19aeccd37c82cb66  
# torch
curl -f -C - -o torch-2.5.1+das.opt1.dtk25042.20260114.g7b1e7e04-cp310-cp310-manylinux_2_28_x86_64.whl https://ksefile.hpccube.com:65241/efile/s/d/bGl0emg=/a7d181806c7829e1  
# lmslim
curl -f -C - -o lmslim-0.3.1+das.opt2.bc977a7.dtk25042-cp310-cp310-linux_x86_64.whl https://ksefile.hpccube.com:65241/efile/s/d/bGl0emg=/3de9e867ee5f7014  
```

### 3. 下载优化包

```bash
# hipblaslt
curl -f -C - -o hipblaslt.tar.gz https://ksefile.hpccube.com:65241/efile/s/d/bGl0emg=/060c023d2a62ec6f  
# 解压到指定路径
tar -xzvf hipblaslt.tar.gz -C /path/to/hipblaslt
```


### 4. 下载模型

安装 ModelScope

```bash
pip install modelscope
```

下载所需模型

```bash
# Wan2.1 过滤不需要的 dit_fp32 权重
modelscope download --model 'Wan-AI/Wan2.1-I2V-14B-480P' --exclude '*.safetensors' --local_dir 'path/to/models'

# 下载 dit_int8 权重
curl -f -C - -o wan2.1_i2v_480p_int8_lightx2v.safetensors https://ksefile.hpccube.com:65241/efile/s/d/bGl0emg=/ea72503e06c25ddb
# 移动到指定路径
mv wan2.1_i2v_480p_int8_lightx2v.safetensors path/to/models
```

---

## 测试脚本（8卡）

脚本位于 `wan2.1-14b-480p-int8-lightx2v/scripts/platforms/hygon_dcu/run_wan21_i2v_int8.sh`, 注意指定项目路径 `lightx2v_path` 和模型权重文件路径 `model_path`

```bash
#!/bin/bash
# System management interface: hy-smi
export PLATFORM=hygon_dcu

# Set paths
# 项目路径
lightx2v_path=/workspace/wan2.1-14b-480p-int8-lightx2v
# 模型下载路径
model_path=path/to/models

# Set HIP devices for 8 GPUs
export HIP_VISIBLE_DEVICES=0,1,2,4,5,6,7

# Set environment variables
source ${lightx2v_path}/scripts/base/base.sh

torchrun --nproc_per_node=8 -m lightx2v.infer \
--model_cls wan2.1 \
--task i2v \
--model_path $model_path \
--config_json ${lightx2v_path}/configs/platforms/hygon_dcu/wan_i2v_int8.json \
--prompt "Summer beach vacation style, a white cat wearing sunglasses sits on a surfboard. The fluffy-furred feline gazes directly at the camera with a relaxed expression. Blurred beach scenery forms the background featuring crystal-clear waters, distant green hills, and a blue sky dotted with white clouds. The cat assumes a naturally relaxed posture, as if savoring the sea breeze and warm sunlight. A close-up shot highlights the feline's intricate details and the refreshing atmosphere of the seaside." \
--negative_prompt "镜头晃动，色调艳丽，过曝，静态，细节模糊不清，字幕，风格，作品，画作，画面，静止，整体发灰，最差质量，低质量，JPEG压缩残留，丑陋的，残缺的，多余的手指，画得不好的手部，画得
不好的脸部，畸形的，毁容的，形态畸形的肢体，手指融合，静止不动的画面，杂乱的背景，三条腿，背景人很多，倒着走" \
--image_path ${lightx2v_path}/assets/inputs/imgs/img_0.jpg \
--save_result_path ${lightx2v_path}/save_results/output_lightx2v_wan_i2v_int8.mp4
```

模型配置文件 `wan2.1-14b-480p-int8-lightx2v/configs/platforms/hygon_dcu/wan_i2v_int8.json`, 注意指定dit_int8模型权重路径 `dit_quantized_ckpt`

```bash
{
    "infer_steps": 40,
    "target_video_length": 81,
    "target_height": 480,
    "target_width": 832,
    "self_attn_1_type": "flash_attn_hygon_dcu",
    "cross_attn_1_type": "flash_attn_hygon_dcu",
    "cross_attn_2_type": "flash_attn_hygon_dcu",
    "sample_guide_scale": 5.0,
    "sample_shift": 5.0,
    "enable_cfg": true,
    "cpu_offload": false,
    "modulate_type": "torch",
    "rope_type": "torch",
    "layer_norm_type": "torch",
    "rms_norm_type": "torch",
    "dit_quantized": true,
    "dit_quant_scheme": "int8-vllm-hygon-dcu",
   "dit_quantized_ckpt": "/path/to/models/wan2.1_i2v_480p_int8_lightx2v.safetensors"
}
```

启动指令

```bash
cd wan2.1-14b-480p-int8-lightx2v
export LD_LIBRARY_PATH=/path/to/hipblaslt/lib/:$LD_LIBRARY_PATH
export USE_SLA=1
export SPARSE_ATTN_TOPK=0.4

bash scripts/platforms/hygon_dcu/run_wan21_i2v_int8.sh
```

---

## 贡献指南

欢迎对 wan2.1-14b-480p-int8-lightx2v 项目进行贡献！请遵循以下步骤：

1. Fork 本仓库，并新建分支进行功能开发或问题修复。
2. 提交规范的 commit 信息，描述清晰。
3. 提交 Pull Request，简述修改内容及目的。
4. 遵守项目代码规范和测试标准。
5. 参与代码评审，积极沟通改进方案。

---

## 许可证

本项目遵循 Apache 2.0 许可证，详见 [LICENSE](./LICENSE) 文件。

---

感谢您的关注与支持！如有问题，欢迎提交 Issue 或联系维护团队。
