for para in $*
do
    if [[ $para == --profiling* ]];then
        profiling=${para#*=}
    fi
done

CURRENT_DIR=$( cd "$( dirname "$0" )" && pwd )
MEGATRON_PATH=$( dirname $( dirname ${CURRENT_DIR}))

# Those variables need to modify
DTK_ENV="/opt/dtk/env.sh"                                                               # where env.sh of dtk
DATA_PATH="/workspace/qwen-oscar/oscar-1GB_head-qwen_text_document"             # path to oscar-1GB_head-qwen_text_document
TOKENIZER_MODEL_PATH="/workspace/Qwen2.5-14B-Instruct"                                                  # path to tokenizer.model
CHECKPOINT_PATH="/workspace/dcu_megatron/examples/qwen/checkpoint"                                                       # path to ckpt
NCCL_ENV=${MEGATRON_PATH}/requirements/env.sh                            # Please adjust the variables based on the actual NET being used
LAUNCH_WITH_BINDING=${MEGATRON_PATH}/requirements/launch_with_binding.sh # Please adjust the variables based on the actual NET being used

# Those variables no need to modify
#HOSTFILE="hostfile_$(basename "$0" | sed -E 's/^run_(.+)\.sh$/\1/')"
#GPUS=$(($(cat ${HOSTFILE}|sort|uniq |wc -l)*8))
GPUS="8"
#HOST="$(cat ${HOSTFILE} |sed -n "1p"|awk -F ' ' '{print $1}')"
PORT="29501"

# Runs Qwen2.5 14B model
source ${NCCL_ENV}
#echo "start mpirun"
mpirun -np ${GPUS}  --allow-run-as-root \
                    --bind-to none \
                    --mca plm_rsh_no_tree_spawn 1 \
		    bash -c "
                    source ${DTK_ENV} && \
                    source ${NCCL_ENV} && \
                    ./train_qwen2.5_14B.sh \
                    localhost \
                    ${PORT} \
                    --data_path=$DATA_PATH \
                    --tokenizer_path=$TOKENIZER_MODEL_PATH \
                    --checkpoint_path=$CHECKPOINT_PATH \
                    --launch_with_binding=${LAUNCH_WITH_BINDING} "  
		    #> log-$((${GPUS} / 8))nodes-`date +%F-%H%M`.log 2>&1

wait
