# qwen2.5-14b-instruct_dcu-megatron

## 项目简介

使用dcu-megatron框架进行Qwen2.5-14B-Instruct预训练

---

## 环境部署

### 1. 拉取镜像

```bash
docker pull harbor.sourcefind.cn:5443/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10
```

### 2. 创建容器

```bash
docker run -it \
--network=host \
--hostname=localhost \
--name=qwen2.5-14B \
-v /opt/hyhal:/opt/hyhal:ro \
-v $PWD:/workspace \
--ipc=host \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
--shm-size=512G \
--privileged \
--group-add video \
--cap-add=SYS_PTRACE \
-u root \
--security-opt seccomp=unconfined \
harbor.sourcefind.cn:5443/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10 \
/bin/bash
```

---

## 测试步骤

### 1. 拉取代码

```bash
git clone http://developer.sourcefind.cn/codes/maming/qwen2.5-14b-instruct_dcu-megatron.git
cd qwen2.5-14b-instruct_dcu-megatron/
```

### 2. 安装依赖

```bash
pip install -r requirements/requirements.txt  

git clone https://github.com/NVIDIA/Megatron-Energon.git
cd Megatron-Energon
git checkout ea11c980

git clone https://github.com/NVIDIA/Megatron-LM.git
cd Megatron-LM
git checkout c550cf6c

pip install pybind11
```

### 3. 下载数据集、模型

数据集oscar，下载地址：

https://r0ddbu55vzx.feishu.cn/drive/folder/HNLpfPoddl833PdEInOc6F7pnmd?from=space_personal_filelist

安装 ModelScope：

```bash
pip install modelscope
```

下载所需模型：

```bash
modelscope download --model Qwen/Qwen2.5-14B-Instruct --local_dir ./Qwen2.5-14B-Instruct
```

---

## 训练脚本（8卡）

```bash
cd examples/qwen/
#修改运行脚本中的数据集、权重文件路径
#dcu_megatron/requirements/目录中的env.sh和launch_with_binding.sh选择wz
bash run_qwen2.5_14B_1node.sh
```

---

## 贡献指南

欢迎对 qwen2.5-14b-instruct_dcu-megatron项目进行贡献！请遵循以下步骤：

1. Fork 本仓库，并新建分支进行功能开发或问题修复。
2. 提交规范的 commit 信息，描述清晰。
3. 提交 Pull Request，简述修改内容及目的。
4. 遵守项目代码规范和测试标准。
5. 参与代码评审，积极沟通改进方案。

---

## 许可证

本项目遵循 MIT 许可证，详见 [LICENSE](./LICENSE) 文件。

---

感谢您的关注与支持！如有问题，欢迎提交 Issue 或联系维护团队。
