# ParticleNet

## 项目简介

## 环境部署
### 1. 拉取镜像
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10
```
### 2. 创建容器
```bash
docker run -it \
    --name ParticleNet \
    --privileged \
    --network=host \
    --ipc=host \
    --shm-size=64G \
    --cap-add=SYS_PTRACE \
    --device=/dev/dri:/dev/dri \
    -v /opt/hyhal:/opt/hyhal:ro \
    -v $PWD:/workspace \
    --security-opt seccomp=unconfined \
    image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10 \
    /bin/bash
```
---

## 测试步骤

### 1. 拉取代码

```bash
cd /workspace

git clone http://developer.sourcefind.cn/codes/modelzoo/particlenet_tensorflow.git

cd particlenet_tensorflow/tf-keras
```
### 2. 安装依赖
```bash
pip install -r requirements.txt
pip install tf_keras==2.18.0  -i https://pypi.tuna.tsinghua.edu.cn/simple --no-deps
```

### 3. 下载数据集


```bash

mkdir original    #在tf-keras目录下创建original目录
cd original       #将数据集下载放到original目录下

curl -O -L https://zenodo.org/record/2603256/files/train.h5
curl -O -L https://zenodo.org/record/2603256/files/test.h5
curl -O -L https://zenodo.org/record/2603256/files/val.h5

cd ..
python convert_dataset.py  # 程序结束后生成converted目录
```

### 4. 执行测试命令
```bash
训练：python keras_train.py
推理：python predict_demo.py
```
