
# hunyuan-t2v

## 项目简介
`hunyuan-t2v` 是一个基于 PyTorch 的视频生成与优化项目，整合了腾讯混元大模型和多种深度学习工具，支持高效视频生成与推理。通过容器化部署和丰富的模型支持，满足复杂环境下的快速开发及测试需求。

## 环境部署

### 1. 拉取容器镜像
```bash
docker pull harbor.sourcefind.cn:5443/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.4-1230-py3.10-20260115
```

### 2. 创建并启动 Docker 容器
```bash
docker run -it \
--network=host \
--hostname=localhost \
--name=hunyuan-t2v \
-v /opt/hyhal:/opt/hyhal:ro \
-v $PWD:/workspace \
--ipc=host \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
--shm-size=512G \
--privileged \
--group-add video \
--cap-add=SYS_PTRACE \
-u root \
--security-opt seccomp=unconfined \
harbor.sourcefind.cn:5443/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.4-1230-py3.10-20260115 \
/bin/bash
```

---

## 测试步骤

### 1. 拉取优化后代码仓库
```bash
git clone http://developer.sourcefind.cn/codes/bw-bestperf/hunyuanvideo-t2v.git
cd hunyuanvideo-t2v
```

### 2. 安装依赖
```bash
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
pip install yunchang==0.6.0 xfuser==0.4.2
bash fix.sh  # 适配 xfuser
```

### 3. 下载并准备模型

安装 ModelScope：
```bash
pip install modelscope
```

下载所需模型：
```bash
# 下载混元视频模型
modelscope download --model Tencent-Hunyuan/HunyuanVideo --local_dir ./ckpts

# 下载 Llava LLaMA 3 8b 模型
modelscope download --model AI-ModelScope/llava-llama-3-8b-v1_1-transformers --local_dir ./ckpts/llava-llama-3-8b-v1_1-transformers

# 下载 CLIP ViT-Large Patch14
modelscope download --model AI-ModelScope/clip-vit-large-patch14 README.md --local_dir ./ckpts/text_encoder2
```

对 `text_encoder` 模型进行转换：
```bash
cd HunyuanVideo
python hyvideo/utils/preprocess_text_encoder_tokenizer_utils.py --input_dir ../ckpts/llava-llama-3-8b-v1_1-transformers --output_dir ../ckpts/text_encoder
```

---

## 测试示例

配置视频参数并运行多卡推理测试：

```bash
len=33
step=20

for num in 1 2 4; do
    torchrun --nproc_per_node=${num} sample_video.py \
        --video-size 1280 720 \
        --video-length ${len} \
        --infer-steps ${step} \
        --prompt "A cat walks on the grass, realistic style." \
        --flow-reverse \
        --seed 42 \
        --ulysses-degree ${num} \
        --ring-degree 1 \
        --save-path ./results 2>&1 | tee 1016-video/bw-video-len_${len}-step_${step}-num-${num}.log
done
```

或者直接使用脚本：
```bash
bash run_len33.sh
```

长视频推理（帧数129）：
```bash
export PYTORCH_NO_HIP_MEMORY_CACHING=1  # 禁用 HIP 缓存 allocator，防止OOM
bash run_len129.sh
```

---

## 配置选项

- `--video-size`: 输出视频分辨率，格式为宽 高，如 `1280 720`
- `--video-length`: 生成视频的帧数长度
- `--infer-steps`: 推理步数
- `--prompt`: 文本提示，指导视频生成内容
- `--flow-reverse`: 是否启用流动反转模式
- `--seed`: 随机种子，保证结果复现
- `--save-path`: 输出结果保存路径

---

## 贡献指南

欢迎大家参与 `hunyuan-t2v` 的优化与功能扩展！  
请遵循以下步骤：

1. Fork 本仓库
2. 新建 feature 分支：`git checkout -b feature/your-feature-name`
3. 进行代码修改，并确保通过测试
4. 提交并推送分支：`git push origin feature/your-feature-name`
5. 创建 Pull Request，描述变更内容和目的

请确保代码风格统一，功能完整，包含必要测试。

---

## 许可证

本项目遵循 **Apache License 2.0** 许可证。详细请查看 [LICENSE](LICENSE) 文件。

---

感谢使用与支持 `hunyuan-t2v`！

如有任何问题，请联系维护团队或提交 Issue。
```
