# HFM

## 模型简介

HFM是一种基于物理学的深度学习框架，能够对控制流体运动的一类重要物理定律进行编码，即纳维-斯托克斯方程。具体来说，我们试图利用底层守恒定律（即质量、动量和能量守恒定律）来推断隐藏的感兴趣量，例如速度和压力场，这些量仅来自在任意复杂域（例如人体动脉或脑动脉瘤）中传输的被动缩放器（例如染料或烟雾）的时空可视化。我们解决上述数据同化问题的方法是独一无二的，因为我们设计了一种与几何形状或初始和边界条件无关的算法。这使得 HFM 在选择感兴趣的时空域进行数据采集以及后续训练和预测时具有高度灵活性。因此，HFM 所做的预测属于纯机器学习策略或单纯的科学计算方法根本无法重现的情况。对于由实际应用引发的几个基准问题，所提出的算法可以准确预测二维和三维流动中的压力和速度场。我们的结果表明，这种相对简单的方法可用于物理和生物医学问题，以提取有价值的定量信息（例如升力和阻力或动脉壁面剪切应力），而这些信息可能无法直接测量。



## 环境配置

### 1. 拉取镜像

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10
```

### 2. 创建容器

```bash
docker run -it \
    --network=host \
    --hostname=localhost \
    --name HFM \
    -v /opt/hyhal:/opt/hyhal:ro \
    -v $PWD:/workspace \
    --ipc=host \
    --device=/dev/kfd \
    --device=/dev/mkfd \
    --device=/dev/dri \
    --shm-size=512G \
    --privileged \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10 \
    /bin/bash
```

---
## 测试步骤

### 1. 拉取代码

```bash
git clone http://developer.sourcefind.cn/codes/bw-bestperf/hfm.git
cd hfm/
```

### 2. 安装依赖

```bash
pip install scipy -i https://mirrors.aliyun.com/pypi/simple/
```
### 3. 获取优化包
```bash
curl -f -C - -o rocblas-install-1126-5bug.tar.gz https://ksefile.hpccube.com:65241/efile/s/d/emhhbmd3YjM=/7420623cbac23efd  
```
#设置环境变量
```bash
CURRENT_DIR=$(pwd)
export LD_LIBRARY_PATH=$CURRENT_DIR/rocblas-install/lib:$LD_LIBRARY_PATH
```
#验证环境变量设置
```bash
echo $LD_LIBRARY_PATH | tr ':' '\n' | head -3
```
### 3. 下载数据集

[数据下载地址](https://o365coloradoedu-my.sharepoint.com/:f:/g/personal/mara4513_colorado_edu/EnMZcTjA6BVBjovGVJT3hk4BIemGxYF9lO6ry0SyizIjoQ?e=fuHKi2)

#仅下载Cylinder2D.mat即可
```
#在当前目录下添加Data目录,并将数据集放到Data目录下
mkdir Data
Data
    ├── Cylinder2D.mat
```


## 训练

```bash
cd Source
export TF_XLA_FLAGS="--tf_xla_auto_jit=1"
numactl --cpunodebind=3 --membind=3 python Cylinder2D.py > Cylinder2D_stdout.txt
```

## 推理

暂无

## 应用场景

### 算法类别

`AI for science`

### 热点应用行业

`科研,教育`

## 参考资料

* https://github.com/maziarraissi/HFM

