# Fourcastnet_train

## 项目简介



---

## 环境部署

### 1. 拉取镜像

```bash
docker pull harbor.sourcefind.cn:5443/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.4-1230-py3.10-20260115
```

### 2. 创建容器

```bash
docker run -it \
--network=host \
--hostname=localhost \
--name=hunyuan \
-v /opt/hyhal:/opt/hyhal:ro \
-v $PWD:/workspace \
--ipc=host \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
--shm-size=512G \
--privileged \
--group-add video \
--cap-add=SYS_PTRACE \
-u root \
--security-opt seccomp=unconfined \
harbor.sourcefind.cn:5443/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.4-1230-py3.10-20260115 \
/bin/bash
```

---

## 测试步骤

### 1. 拉取代码

```bash
git clone http://developer.sourcefind.cn/codes/bw-bestperf/hunyuanvideo-i2v.git
cd hunyuanvideo-i2v/
```

### 2. 安装依赖

```bash
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

pip install yunchang==0.6.0 xfuser==0.4.2

bash fix.sh  # 适配xfuser
```

### 3. 下载模型

安装 ModelScope：

```bash
pip install modelscope
```

下载所需模型：

```bash
mkdir ckpts

modelscope download --model Tencent-Hunyuan/HunyuanVideo --local_dir ./ckpts

modelscope download --model AI-ModelScope/HunyuanVideo-I2V --local_dir ./ckpts

modelscope download --model AI-ModelScope/clip-vit-large-patch14 --local_dir ckpts/text_encoder_2

modelscope download --model AI-ModelScope/llava-llama-3-8b-v1_1-transformers --local_dir ckpts/text_encoder_i2v
```

执行修复脚本：

```bash
bash modified/fix.sh
```

设置环境变量，禁用 HIP 缓存 allocator 防止 OOM：

```bash
export PYTORCH_NO_HIP_MEMORY_CACHING=1
```

---

## 测试代码示例（四卡多GPU测试）

导出设备环境和禁用缓存：

```bash
export HIP_VISIBLE_DEVICES=4,5,6,7
export PYTORCH_NO_HIP_MEMORY_CACHING=1
```

运行文本到视频多GPU推理：

```bash
ALLOW_RESIZE_FOR_SP=1 torchrun --nproc_per_node=4 \
    sample_image2video.py \
    --model HYVideo-T/2 \
    --prompt "An Asian man with short hair in black tactical uniform and white clothes waves a firework stick." \
    --i2v-mode \
    --i2v-image-path ./assets/demo/i2v/imgs/0.jpg \
    --i2v-resolution 720p \
    --i2v-stability \
    --infer-steps 50 \
    --video-length 129 \
    --flow-reverse \
    --flow-shift 17.0 \
    --seed 42 \
    --embedded-cfg-scale 6.0 \
    --save-path ./results \
    --ulysses-degree 4 \
    --ring-degree 1 \
    --num-videos 1 2>&1 | tee z_logs/bw_image2video_4ka.log
```

---

## 配置选项说明

| 参数                 | 说明                           | 默认值 / 示例                             |
| -------------------- | ------------------------------ | ---------------------------------------- |
| `--model`            | 指定使用的模型名称             | `HYVideo-T/2`                            |
| `--prompt`           | 文本描述，用于生成视频         | `"An Asian man with short hair..."`     |
| `--i2v-mode`         | 启用文本到视频模式             |                                          |
| `--i2v-image-path`   | 输入图像路径                   | `./assets/demo/i2v/imgs/0.jpg`          |
| `--i2v-resolution`   | 输出视频分辨率                 | `720p`                                  |
| `--i2v-stability`    | 稳定性增强选项                 |                                          |
| `--infer-steps`      | 推理步数，影响生成质量与速度   | `50`                                    |
| `--video-length`     | 生成视频的长度（帧数）         | `129`                                   |
| `--flow-reverse`     | 是否反转光流                   |                                          |
| `--flow-shift`       | 光流偏移值                     | `17.0`                                  |
| `--seed`             | 随机种子，保证结果可复现       | `42`                                    |
| `--embedded-cfg-scale` | Condition scaling比例          | `6.0`                                   |
| `--save-path`        | 生成结果保存路径               | `./results`                             |
| `--ulysses-degree`   | 自定义参数，具体含义见代码说明 | `4`                                     |
| `--ring-degree`      | 自定义参数，具体含义见代码说明 | `1`                                     |
| `--num-videos`       | 生成视频数量                   | `1`                                     |

---

## 贡献指南

欢迎对 hunyuan-I2V 项目进行贡献！请遵循以下步骤：

1. Fork 本仓库，并新建分支进行功能开发或问题修复。
2. 提交规范的 commit 信息，描述清晰。
3. 提交 Pull Request，简述修改内容及目的。
4. 遵守项目代码规范和测试标准。
5. 参与代码评审，积极沟通改进方案。

---

## 许可证

本项目遵循 MIT 许可证，详见 [LICENSE](./LICENSE) 文件。

---

感谢您的关注与支持！如有问题，欢迎提交 Issue 或联系维护团队。
