# Fourcastnet_train

## 项目简介



---

## 环境部署

### 1. 拉取镜像

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250913-rc1
```

### 2. 创建容器

```bash
docker run -it \
    --network=host \
    --hostname=localhost \
    --name FourCastNet_train \
    -v /opt/hyhal:/opt/hyhal:ro \
    -v $PWD:/workspace \
    --ipc=host \
    --device=/dev/kfd \
    --device=/dev/mkfd \
    --device=/dev/dri \
    --shm-size=512G \
    --privileged \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250913-rc1 \
    /bin/bash
```

---

## 测试步骤

### 1. 拉取代码

```bash
git clone http://developer.sourcefind.cn/codes/bw_bestperf/fourcastnet_train.git
cd fourcastnet_train/
```

### 2. 安装依赖

```bash
pip install wandb pybind11 h5py ruamel.yaml timm -i https://pypi.tuna.tsinghua.edu.cn/simple
```

### 3. 下载数据集

```bash
#下载数据集data 包含train和valid数据集
curl -f -C - -o data.tar.gz https://ksefile.hpccube.com:65241/efile/s/d/ZGN1X2Vjbw==/fe9a61dbaca9de37
#下载的文件应按以下层次结构组织
data/
├── global_means.npy
├── global_stds.npy
├── time_means.npy
├── train/
└── valid/
```


## 测试命令

```bash
bash run.sh
```


