# YOLOV5_PyTorch口罩检测

## 1.模型介绍

[YOLO](https://arxiv.org/abs/1506.02640)（You Only Look Once）是一种流行的对象检测和图像分割模型，由华盛顿大学的Joseph Redmon和Ali Farhadi开发。YOLO 于 2015 年推出，因其高速和准确性而迅速普及。

- [YOLOv2](https://arxiv.org/abs/1612.08242)于2016年发布，通过合并批处理规范化、锚框和维度集群改进了原始模型。
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf) 于 2018 年推出，使用更高效的主干网络、多个锚点和空间金字塔池化进一步增强了模型的性能。
- [YOLOv4](https://arxiv.org/abs/2004.10934) 于 2020 年发布，引入了 Mosaic 数据增强、新的无锚检测头和新的损失函数等创新。
- [YOLOv5](https://github.com/ultralytics/yolov5) 进一步提升了模型的性能，并增加了超参数优化、集成实验跟踪和自动导出为流行导出格式等新功能。

## 2.模型结构

YOLOv5是一种基于深度学习的目标检测算法，它的模型结构主要包括backbone、neck、head和loss四个部分。其中，backbone是用于提取特征的主干网络，neck是用于融合不同层次的特征，head是用于预测目标的检测头，loss是用于计算损失的函数。YOLOv5的模型结构相比YOLOv4有所改进，主要体现在backbone和head上。

更具体地说，YOLOv5的backbone采用CSPDarknet53网络结构，其中CSP表示Cross Stage Partial Network，它可以有效地减少参数量和计算量。neck采用FPN+PAN的结构，其中FPN表示Feature Pyramid Network，PAN表示Path Aggregation Network，它们可以将不同层次的特征进行融合。head采用YOLOv3中的anchor-based检测头，并在此基础上加入了SPP结构和SAM结构，以提高检测精度。loss采用GIOU Loss作为bounding box的损失，并使用二进制交叉熵和Logits损失函数计算类概率和目标得分的损失。

## 3.数据集
### 一

1. 数据集名称：深度学习人脸口罩数据集
2. 数据量：两个数据集，一个1600张图片，一个7056张图片
3. 标注框种类：face（人脸）、face_mask（戴口罩）、共两类
4. 标签格式：均为voc格式
5. 收集来源：主要为网络收集
6. 备注：自己做项目用过的两个人脸-口罩数据集，质量都很高

### 二
使用COCO2017数据集，COCO2017数据集是一个用于目标检测、分割、关键点检测和图像描述的数据集，由微软公司制作收集。该数据集包含超过33万张图像，其中大约20万张图像用于训练，6万张图像用于验证，7万张图像用于测试。COCO2017数据集中的物体类别共有80个，包括人、动物、交通工具、家具等。
COCO2017数据集中的每个物体都有一个矩形边界框和一个类别标签，同时还有一些物体的关键点标注和图像描述信息。COCO2017数据集的标注格式采用JSON文件存储，其中包含了每个物体的位置、类别、关键点等信息。
## 4.训练

### 环境配置

提供光源拉取的训练镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py38-latest
```

python依赖安装：

```
pip3 install -r requirement.txt
```

本地安装PyTorch1.7

```
    # 安装torch
    pip install /public/software/apps/DeepLearning/whl/dtk-21.04/torch-1.8.0a0+56b43f4-cp37-cp37m-linux_x86_64.whl
    # 安装torchvision
    pip install /public/software/apps/DeepLearning/whl/dtk-21.04/torchvision-0.9.0a0-cp37-cp37m-linux_x86_64.whl

```
在本地创建一个pytorch_env.sh的文件，添加环境变量:
```
vi  ~/pytorch_env.sh

export
LD_LIBRARY_PATH=/public/software/apps/DeepLearning/PyTorch_Lib/lib:/public/software/apps/DeepLearning/PyTorch_Lib/lmdb-0.9.24-build/lib:/public/software/apps/DeepLearning/PyTorch_Lib/opencv-2.4.13.6-build/lib:/public/software/apps/DeepLearning/PyTorch_Lib/openblas-0.3.7-build/lib:$LD_LIBRARY_PATH

# 记得以后每次登录新的节点时，一定要执行一次source ~/pytorch_env.sh命令，这关系到服务器能不能找到PyTorch
source ~/pytorch_env.sh
```
### 预训练模型

预训练模型均在models文件夹内

### 单卡训练

```
export HIP_VISIBLE_DEVICES=0

python3 train.py --batch 32 --data /work/home/acqpriwny1/cyh/datasets/MaskDataSet/data.yaml --cfg 'yolov5s.yaml' --weights '' --project 'run/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --epochs 1000  2>&1 | tee  yolov5s.log
```
![image](1.PNG) 
### 单节点多卡训练

```
#以单机四卡为例子
export HIP_VISIBLE_DEVICES=0,1,2,3

python3 -m torch.distributed.run --nproc_per_node 4 train.py --batch 128 --data coco.yaml --cfg 'yolov5m.yaml' --weights '' --project 'run/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --device 0,1,2,3 --epochs 1000 2>&1 | tee  yolov5m_4.log
```

其中--nproc_per_node参数代表卡的个数，--batch参数代表global batchsize的大小

![image](b1f15f6dfece4c81963cfb63c792ee15.png) 

训练结束后会输出best.pt和last.pt到runs/train/exp

![image](2.PNG)

**注意--workers 的default值需要修改为0，否则编译报错。**

![image](3.PNG)

#### 训练所有结果的图表和记录结果的csv均存放在runs/train文件夹下，以下只放几张：

![image](runs/train/val_batch0_pred.jpg))

![image](runs/train/PR_curve.png)

![image](runs/train/results.png)

![image](runs/train/confusion_matrix.png)
## 推理测试（以口罩检测为例）
```
python detect.py --source 0  # webcam
                          file.jpg  # image 
                          file.mp4  # video
                          path/  # directory
                          path/*.jpg  # glob
                          'https://youtu.be/NUsoVlDFqZg'  # YouTube
                          'rtsp://example.com/media.mp4'  # RTSP, RTMP, HTTP stream

```
detect.py 在各种来源上运行 YOLOv5 推论，从最新的 YOLOv5 版本中自动下载模型，并将结果保存到 runs/detect 中。推理源示例如下
```
python detect.py --weights yolov5s.pt --img 640 --conf 0.25 --source data/images/
Image(filename='runs/detect/exp/zidane.jpg', width=600)
```
![image](捕获.PNG) 

![image](runs/detect/5c1ad8e25c3fa0de61250124e1973eb6__1_.jpg) 

![image](runs/detect/6cf9d7ce36f2e52c3aec828bdc3ff548__1_.jpeg) 

![image](runs/detect/89ee4a1ccecd593dd4ce32d9f15f7b58__1_.jpg) 

![image](runs/detect/bus.jpg) 

将训练好的pt文件导入weight参数中即可，推理代码如下：

```
python3 val.py --data data/data.yaml --weights runs/train/exp12/weights/best.pt --device 0
```

##口罩检测

##ONNX模型单张图片推理并导出（根据coco128数据集训练的模型） 
在export.py 中的 def parse_opt()函数修改：
```
修改 default=12
parser.add_argument('--simplify', action='store_true', help='ONNX: simplify model')
    parser.add_argument('--opset', type=int, default=12, help='ONNX: opset version')
```
在yolov5目录下执行模型导出脚本
```
python export.py --weights yolov5s.pt --include onnx
```
用准备好的模型推理代码进行推理，并将结果输出为res.jpg：
```
#输入图片修改output, or_img = model.inference('Image00003.jpg')

python yolov5_detection.py
```
![image](qb5636zq.png)

![image](w9jdchyv.png)
## 准确率

|  模型   | size（pixels) | map0.5:0.95 | map0.5 |
| :-----: | :------: | :---------: | :----: |
| yolov5n |   640   |    27.9     |  46.8  |
| yolov5s |   640   |    37.2     |  57.1  |
| yolov5m |   640   |    44.3     |  64.1  |
| yolov5l |   640   |     48      |  67.3  |
| yolov5x |   640   |    49.6     |  68.6  |



## 源码仓库及问题反馈
https://developer.hpccube.com/codes/acqpriwny1/yolov-5-pytorch/

## 参考

[GitHub - ultralytics/yolov5 at v6.1]https://github.com/ultralytics/yolov5/releases/tag/v6.1)


