# 仓库目录结构
## 除预训练模型外其他文件总大小尽量不要超过50M

    Project
    ├── imgs
    │   ├── xxx.jpg
    │   └── xxx.jpg
    ├── model
    │   ├── xxx.pth #预训练模型 
    │   ├── xxx.onnx #对应的onnx模型
    │   └── xxx.mxr #对应的migraphx离线推理模型
    ├── icon.png
    ├── README.md
    ├── requirement.txt
    ├── model.properties
    ├── code_file1.py
    ├── code_file2.py
    ├── code_file3.py
    ├── dirs
    │   ├── code_file4.py
    │   ├── code_file5.py
    └── └── code_file6.py
### icon.png:模型的图标文件，可到[iconfont](https://www.iconfont.cn/?spm=a313x.7781069.1998910419.d4d0a486a)查找。
### README.md:参照本文件下面部分。
### requirement.txt：模型依赖统一写到此文件。
### model.properties：固定模板如下：

    # 模型名称
    modelName=模型名称(同项目名称)
    # 模型描述
    modelDescription=简要描述此模型(尽量50字以内)
    # 应用场景
    appScenario=推理,训练,OCR,nlp,cv,车牌识别,目标检测(首先描述推理训练信息，然后描述领域信息，多个标签用英文逗号隔开)
    # 框架类型
    frameType=Tensorflow,PyTorch,Migraphx,ONNXRuntime(说明使用的框架类型, 多个标签用英文逗号隔开)

以下是README.md的编写框架：

# 模型名称(此处需修改，用英文全称与简写)
## 模型介绍
此处填写模型介绍。
## 模型结构
此处简要介绍模型结构。
## 数据集
此处介绍使用的数据集

如添加了自己写的数据集处理脚本，在此处说明脚本的使用方法：

    python xxx.py \
        --args0 xxx \
        --args1 xxx  \
        ...
## 训练及推理
### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练以及推理的docker镜像：
* 训练镜像：
* 推理镜像：

python依赖安装：

    pip install -r requirement.txt
### 训练与Fine-tunning
训练命令：

    python train.py \
        --args0 xxx \
        --args1 xxx  \
        ...

Fine-tunning命令：

    python train.py \
        --args0 xxx \
        --args1 xxx  \
        ...
### 预训练模型
model文件夹提供的预训练模型介绍，例如：

    Project
    ├── model
    │   ├── xxx.pth #pytorch预训练模型 
    │   ├── xxx.onnx #对应的onnx模型
    └── └── xxx.mxr #对应的migraphx离线推理模型
### 测试
测试命令：

    python test.py \
        --args0 xxx \
        --args1 xxx
        ...

### 推理
推理引擎版本：
* ONNXRuntime(DCU版本) >= x.xx.x
* Migraphx(DCU版本) >= x.x.x
#### ORT
基于ORT的推理命令：

    python ORT_infer.py \
        --args0 xxx \
        --args1 xxx \
        ...
#### Migraphx
基于Migraphx的推理命令：

    python Migraphx_infer.py \
        --args0 xxx \
        --args1 xxx \
        ...

## 性能和准确率数据
测试数据：[test data](链接)，使用的加速卡:xxx。

根据模型情况填写表格：
| xxx | xxx | xxx | xxx | xxx |
| :------: | :------: | :------: | :------: |:------: |
| xxx | xxx | xxx | xxx | xxx  |
| xxx | xx | xxx | xxx | xxx |
## 源码仓库及问题反馈
* 仓库的https链接
## 参考
* 链接1
* 链接2
* ......
