import json

# 初始化变量
total_time = 0.0
total_data = 0
count = 0

# 读取文件并计算100-200次迭代的耗时
with open('/home/BEVFormer/work_dirs/bevformer_tiny/20250725_143253.log.json', 'r') as f:  # 替换为你的文件名
    for line in f:
        # 解析 JSON 行
        log_entry = json.loads(line.strip())
        
        # 检查是否是训练模式且有有效的iter值
        if log_entry.get('mode') == 'train' and 'iter' in log_entry:
            iter_num = log_entry['iter']
            
            # 只处理100到200次迭代（包含100和200）
            if 101 <= iter_num <= 200:
                total_time += log_entry['time']
                total_data += log_entry['data_time']
                count += 1
                
            # 超过200次迭代后停止读取
            if iter_num > 200:
                break

# 输出结果
if count > 0:
    print(f"第101到第200次迭代的耗时总和: {total_time:.4f} 秒")
    print(f"第101到第200次迭代的处理数据耗时总和: {total_data:.4f} 秒")
    print(f"涉及迭代次数: {count} 次")
    print(f"平均每次迭代耗时: {total_time/count:.4f} 秒")
else:
    print("未找到101-200次迭代的记录")