#!/bin/bash

# set path and first
lightx2v_path=/data/nvme2/wushuo/LightX2V
model_path=/data/nvme2/wushuo/hf_models/Skywork/Matrix-Game-2.0

export CUDA_VISIBLE_DEVICES=0

# set environment variables
source ${lightx2v_path}/scripts/base/base.sh

python -m lightx2v.infer \
--model_cls wan2.1_sf_mtxg2 \
--task i2v \
--model_path $model_path \
--config_json ${lightx2v_path}/configs/matrix_game2/matrix_game2_gta_drive_streaming.json \
--prompt '' \
--image_path gta_drive/0003.png \
--save_result_path ${lightx2v_path}/save_results/output_lightx2v_matrix_game2_gta_drive_streaming.mp4 \
--seed 42
