# 准备环境

我们推荐使用docker环境，这是lightx2v的[dockerhub](https://hub.docker.com/r/lightx2v/lightx2v/tags)，请选择一个最新日期的tag，比如25042502

```shell
docker pull lightx2v/lightx2v:25042502
docker run --gpus all -itd --ipc=host --name [容器名] -v [挂载设置]  --entrypoint /bin/bash [镜像id]
```

如果你想使用conda自己搭建环境，可以参考如下步骤：

```shell
# 下载github代码
git clone https://github.com/ModelTC/lightx2v.git lightx2v && cd lightx2v
git submodule update --init --recursive

conda create -n lightx2v python=3.11 && conda activate lightx2v
pip install -r requirements.txt

# 单独重新安装transformers，避免pip的冲突检查
# 混元模型需要在4.45.2版本的transformers下运行，如果不需要跑混元模型，可以忽略
pip install transformers==4.45.2

# 安装 flash-attention 2
cd lightx2v/3rd/flash-attention && pip install --no-cache-dir -v -e .

# 安装 flash-attention 3, 用于 hopper 显卡
cd lightx2v/3rd/flash-attention/hopper && pip install --no-cache-dir -v -e .
```

# 推理

```shell
# 修改脚本中的路径
bash scripts/run_wan_t2v.sh
```

除了脚本中已有的输入参数，`--config_json`指向的`${lightx2v_path}/configs/wan_t2v.json`中也会存在一些必要的参数，可以根据需要，自行修改。
