# 量化

lightx2v支持对linear进行量化推理，支持w8a8和fp8的矩阵乘法。


### 运行量化推理

```shell
# 修改脚本中的路径
bash scripts/run_wan_t2v_save_quant.sh
```

脚本中，有两个执行命令：

#### save quantization weight

将`RUNNING_FLAG`环境变量设置成`save_naive_quant`，`--config_json`指向到该`json`文件: `${lightx2v_path}/configs/wan_t2v_save_quant.json`，其中`quant_model_path`会保存下量化的模型的路径

#### load quantization weight and inference

将`RUNNING_FLAG`环境变量设置成`infer`，`--config_json`指向到第一步中的`json`文件

### 启动量化服务

在存好量化权重之后，和上一步加载步骤一样，将`RUNNING_FLAG`环境变量设置成`infer`，`--config_json`指向到第一步中的`json`文件

比如，将`scripts/start_server.sh`脚本进行如下改动：

```shell
export RUNNING_FLAG=infer

python -m lightx2v.api_server \
--model_cls wan2.1 \
--task t2v \
--model_path $model_path \
--config_json ${lightx2v_path}/configs/wan_t2v_save_quant.json \
--port 8000
```
