# How to Start the Service

lightx2v provides asynchronous service functionality. The code entry point is [here](https://github.com/ModelTC/lightx2v/blob/main/lightx2v/api_server.py)


### Start the Service

```shell
# Modify the paths in the script
bash scripts/start_server.sh
```

The `--port 8000` option means the service will bind to port `8000` on the local machine. You can change this as needed.


### Client Sends Request

```shell
python scripts/post.py
```

The service endpoint is: `/v1/local/video/generate`

The `message` parameter in `scripts/post.py` is as follows:


```python
message = {
    "task_id": generate_task_id(),
    "task_id_must_unique": True,
    "prompt": "Two anthropomorphic cats in comfy boxing gear and bright gloves fight intensely on a spotlighted stage.",
    "negative_prompt": "色调艳丽，过曝，静态，细节模糊不清，字幕，风格，作品，画作，画面，静止，整体发灰，最差质量，低质量，JPEG压缩残留，丑陋的，残缺的，多余的手指，画得不好的手部，画得不好的脸部，畸形的，毁容的，形态畸形的肢体，手指融合，静止不动的画面，杂乱的背景，三条腿，背景人很多，倒着走",
    "image_path": "",
    "save_video_path": "./output_lightx2v_wan_t2v_t02.mp4",
}
```

1. `prompt`, `negative_prompt`, and `image_path` are basic inputs for video generation. `image_path` can be an empty string, indicating no image input is needed.

2. `save_video_path` specifies the path where the generated video will be saved on the server. The relative path is relative to the server's startup directory. It is recommended to set an absolute path according to your environment.

3. `task_id` is the ID of the task, which is a string. You can customize a string or use the `generate_task_id()` function to generate a random string. The task ID is used to distinguish between different video generation tasks.

4. `task_id_must_unique` indicates whether each `task_id` must be unique. If set to `False`, there is no such restriction. In this case, if duplicate `task_id`s are sent, the server's `task` record will be overwritten by the newer task with the same `task_id`. If you do not need to keep a record of all tasks for querying, you can set this to `False`.


### Client Checks Server Status

```shell
python scripts/check_status.py
```

The service endpoints include:

1. `/v1/local/video/generate/service_status` is used to check the status of the service. It returns whether the service is `busy` or `idle`. The service only accepts new requests when it is `idle`.

2. `/v1/local/video/generate/get_all_tasks` is used to get all tasks received and completed by the server.

3. `/v1/local/video/generate/task_status` is used to get the status of a specified `task_id`. It returns whether the task is `processing` or `completed`.


### Client Stops the Current Task on the Server at Any Time

```shell
python scripts/stop_running_task.py
```

The service endpoint is: `/v1/local/video/generate/stop_running_task`

After terminating the task, the server will not exit but will return to waiting for new requests.
