# 如何启动服务

lightx2v提供了异步服务功能，代码入口处在[这里](https://github.com/ModelTC/lightx2v/blob/main/lightx2v/api_server.py)


### 启动服务

```shell
# 修改脚本中的路径
bash scripts/start_server.sh
```

其中的`--port 8000`表示服务绑定在本机的`8000`端口上，可以自行修改


### 客户端发送请求

```shell
python scripts/post.py
```

服务的接口是：`/v1/local/video/generate`

`scripts/post.py`中的`message`参数如下：

```python
message = {
    "task_id": generate_task_id(),
    "task_id_must_unique": True,
    "prompt": "Two anthropomorphic cats in comfy boxing gear and bright gloves fight intensely on a spotlighted stage.",
    "negative_prompt": "色调艳丽，过曝，静态，细节模糊不清，字幕，风格，作品，画作，画面，静止，整体发灰，最差质量，低质量，JPEG压缩残留，丑陋的，残缺的，多余的手指，画得不好的手部，画得不好的脸部，畸形的，毁容的，形态畸形的肢体，手指融合，静止不动的画面，杂乱的背景，三条腿，背景人很多，倒着走",
    "image_path": "",
    "save_video_path": "./output_lightx2v_wan_t2v_t02.mp4",
}
```

1. `prompt`, `negative_prompt`, `image_path`是一些基础的视频生成的输入，`image_path`可以为空字符，表示不需要图片输入

2. `save_video_path`表示服务端生成的视频的路径，相对路径是相对服务端的启动路径，建议根据你自己的环境，设置一个绝对路径。

3. `task_id`表示该任务的id，格式是一个字符串。可以自定义个字符串，也可以调用`generate_task_id()`函数生成一个随机的字符串。任务的id用来区分不同的视频生成任务。

4. `task_id_must_unique`表示是否要求每个`task_id`是独一无二的，即不能发有重复的`task_id`。如果是`False`，就没有这个强制要求，此时如果发送了重复的`task_id`，服务端的`task`记录将会被相同`task_id`的较新的`task`覆盖掉。如果不需要记录所有的`task`以用于查询，那这里就可以设置成`False`。


### 客户端获取服务端的状态

```shell
python scripts/check_status.py
```

其中服务的接口有：

1. `/v1/local/video/generate/service_status`用于检查服务的状态，可以返回得到服务是`busy`还是`idle`，只有在`idle`状态，该服务才会接收新的请求。

2. `/v1/local/video/generate/get_all_tasks`用于获取服务端接收到的且已完成的所有的任务。

3. `/v1/local/video/generate/task_status`用于获取指定`task_id`的状态，可以返回得到该任务是`processing`还是`completed`。


### 客户端随时终止服务端当前的任务

```shell
python scripts/stop_running_task.py
```

服务的接口是：`/v1/local/video/generate/stop_running_task`

终止了任务之后，服务端并不会退出服务，而是回到等待接收新请求的状态。

### 单节点同时起多个服务

在单节点上，可以多次使用`scripts/start_server.sh`同时起多个服务（注意同一个ip下的端口号，不同服务之间要保持不同），也可以直接通过`scripts/start_multi_servers.sh`一次性起多个服务：

```shell
num_gpus=8 bash scripts/start_multi_servers.sh
```

其中`num_gpus`表示启动的服务数；服务将在`--start_port`开始的连续`num_gpus`个端口上运行。


### 多个服务之间的调度

```shell
python scripts/post_multi_servers.py
```

`post_multi_servers.py`会根据服务的空闲状态，调度客户端发起的多个请求。
