# 变分辨率推理

## 概述

变分辨率推理是一种优化去噪过程的技术策略，通过在不同的去噪阶段采用不同的分辨率来提升计算效率并保持生成质量。该方法的核心思想是：在去噪过程的前期使用较低分辨率进行粗略去噪，在后期切换到正常分辨率进行精细化处理。

## 技术原理

### 分阶段去噪策略

变分辨率推理基于以下观察：

- **前期去噪**：主要处理粗糙的噪声和整体结构，不需要过多的细节信息
- **后期去噪**：专注于细节优化和高频信息恢复，需要完整的分辨率信息

### 分辨率切换机制

1. **低分辨率阶段**（前期）
   - 将输入降采样到较低分辨率（如原尺寸的0.75）
   - 执行初始的去噪步骤
   - 快速移除大部分噪声，建立基本结构

2. **正常分辨率阶段**（后期）
   - 将第一步的去噪结果上采样回原始分辨率
   - 继续执行剩余的去噪步骤
   - 恢复细节信息，完成精细化处理


### U型分辨率策略

如果在刚开始的去噪步，降低分辨率，可能会导致最后的生成的视频和正常推理的生成的视频，整体差异偏大。因此可以采用U型的分辨率策略，即最一开始保持几步的原始分辨率，再降低分辨率推理。

## 使用方式

变分辨率推理的config文件在[这里](https://github.com/ModelTC/LightX2V/tree/main/configs/changing_resolution)

通过指定--config_json到具体的config文件，即可以测试变分辨率推理。

可以参考[这里](https://github.com/ModelTC/LightX2V/blob/main/scripts/changing_resolution)的脚本运行。


### 举例1：
```
{
    "infer_steps": 50,
    "changing_resolution": true,
    "resolution_rate": [0.75],
    "changing_resolution_steps": [25]
}
```

表示总步数为50，1到25步的分辨率为0.75倍原始分辨率，26到最后一步的分辨率为原始分辨率。

### 举例2：
```
{
    "infer_steps": 50,
    "changing_resolution": true,
    "resolution_rate": [1.0, 0.75],
    "changing_resolution_steps": [10, 35]
}
```

表示总步数为50，1到10步的分辨率为原始分辨率，11到35步的分辨率为0.75倍原始分辨率，36到最后一步的分辨率为原始分辨率。

通常来说，假设`changing_resolution_steps`为[A, B, C]，去噪的起始步为1，总步数为X，则推理会被分成4个部分。

分别是，(0, A], (A, B]. (B, C], (C, X]，每个部分是左开右闭集合。
