

# YOLOV5算力测试

## 1.模型介绍

[YOLO](https://arxiv.org/abs/1506.02640)（You Only Look Once）是一种流行的对象检测和图像分割模型，由华盛顿大学的Joseph Redmon和Ali Farhadi开发。YOLO 于 2015 年推出，因其高速和准确性而迅速普及。

- [YOLOv2](https://arxiv.org/abs/1612.08242)于2016年发布，通过合并批处理规范化、锚框和维度集群改进了原始模型。
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf) 于 2018 年推出，使用更高效的主干网络、多个锚点和空间金字塔池化进一步增强了模型的性能。
- [YOLOv4](https://arxiv.org/abs/2004.10934) 于 2020 年发布，引入了 Mosaic 数据增强、新的无锚检测头和新的损失函数等创新。
- [YOLOv5](https://github.com/ultralytics/yolov5) 进一步提升了模型的性能，并增加了超参数优化、集成实验跟踪和自动导出为流行导出格式等新功能。

## 2.模型结构

YOLOv5是一种基于深度学习的目标检测算法，它的模型结构主要包括backbone、neck、head和loss四个部分。其中，backbone是用于提取特征的主干网络，neck是用于融合不同层次的特征，head是用于预测目标的检测头，loss是用于计算损失的函数。YOLOv5的模型结构相比YOLOv4有所改进，主要体现在backbone和head上。

更具体地说，YOLOv5的backbone采用CSPDarknet53网络结构，其中CSP表示Cross Stage Partial Network，它可以有效地减少参数量和计算量。neck采用FPN+PAN的结构，其中FPN表示Feature Pyramid Network，PAN表示Path Aggregation Network，它们可以将不同层次的特征进行融合。head采用YOLOv3中的anchor-based检测头，并在此基础上加入了SPP结构和SAM结构，以提高检测精度。loss采用GIOU Loss作为bounding box的损失，并使用二进制交叉熵和Logits损失函数计算类概率和目标得分的损失。

## 3.数据集

使用COCO2017数据集，COCO2017数据集是一个用于目标检测、分割、关键点检测和图像描述的数据集，由微软公司制作收集。该数据集包含超过33万张图像，其中大约20万张图像用于训练，6万张图像用于验证，7万张图像用于测试。COCO2017数据集中的物体类别共有80个，包括人、动物、交通工具、家具等。

COCO2017数据集中的每个物体都有一个矩形边界框和一个类别标签，同时还有一些物体的关键点标注和图像描述信息。COCO2017数据集的标注格式采用JSON文件存储，其中包含了每个物体的位置、类别、关键点等信息。

## 4.训练

### 环境配置

提供光源拉取的训练镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py38-latest
```

python依赖安装：

```
pip3 install -r requirement.txt
```

进行训练之前需要对bn进行设置，下面给出示例（function.py的路径根据所用环境进行调整）：

```
#具体路径根据当前所使用的python环境进行修正
vim /usr/local/lib/python3.8/site-packages/torch/nn/functional.py
```

如图将torch.backends.cudnn.enabled改为False

![native bn](native bn.png)

### 预训练模型

预训练模型均在Checkpoints文件夹内

### 单卡训练

```
export HIP_VISIBLE_DEVICES=0

python3 train.py --batch 32 --data coco.yaml --cfg 'yolov5m.yaml' --weights '' --project 'run/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --epochs 1000  2>&1 | tee  yolov5m.log
```

### 单节点多卡训练

```
#以单机四卡为例子
export HIP_VISIBLE_DEVICES=0,1,2,3

python3 -m torch.distributed.run --nproc_per_node 4 train.py --batch 128 --data coco.yaml --cfg 'yolov5m.yaml' --weights '' --project 'run/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --device 0,1,2,3 --epochs 1000 2>&1 | tee  yolov5m_4.log
```

其中--nproc_per_node参数代表卡的个数，--batch参数代表global batchsize的大小

### 多节点多卡

```
#下面的例子中使用两个节点，每个节点包含4加速张卡
#node 1
python3 -m torch.distributed.launch --nproc_per_node 4 --nnodes 2 --node_rank 0 --master_addr "node1" --master_port 34567 train.py --batch 256 --data coco.yaml --weight '' --project 'multi/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --cfg 'yolov5m.yaml' --epochs 1000  2>&1 | tee  yolov5m_8.log

#node2
python3 -m torch.distributed.launch --nproc_per_node 4 --nnodes 2 --node_rank 1 --master_addr "node1" --master_port 34567 train.py --batch 256 --data coco.yaml --weight '' --project 'multi/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --cfg 'yolov5m.yaml' --epochs 1000  2>&1 | tee  yolov5m_8.log
```

**tips：需要注意的是，在超参数的选取上，小模型使用hyp.scratch-low，例如yolov5s，而大模型需要使用hyp.scratch-high，例如yolov5m，它们的区别为，low有更快的收敛速度，而high参数收敛速度慢，但是不容易陷入局部最优。**

## 推理测试

将训练好的pt文件导入weight参数中即可，推理代码如下：

```
python3 val.py --data data/coco-v5.yaml --weights runs/train/exp12/weights/best.pt --device 0
```

## 画出loss和精度曲线

如果在训练一段时间后想要得到类似上述的loss及map曲线，我们提供了view_code.py文件，只需要将您训练过程中--project 指定的路径写入，之后执行python3 view_code.py即可在该路径下得到曲线的图像。

## pycocotools输出结果特别低问题

在训练结束或者推理结束后有时候会发现pycocotools输出的结果异常，数值会非常低，而训练过程中结果正常，如下图所示：

![pycoco错误结果](pycoco_false_result.png)

这是由于python的版本过低导致的问题，除了升级Python版本外，还可以对代码进行修改也可以解决问题，将val.py文件中的如图所示位置，注释掉红框部分的代码也可得到正确的结果。

![pycocotools](pycocotools.png)



## 准确率数据

|  模型   | 数据类型 | map0.5:0.95 | map0.5 |
| :-----: | :------: | :---------: | :----: |
| yolov5n |   混精   |    27.9     |  46.8  |
| yolov5s |   混精   |    37.2     |  57.1  |
| yolov5m |   混精   |    44.3     |  64.1  |
| yolov5l |   混精   |     48      |  67.3  |
| yolov5x |   混精   |    49.6     |  68.6  |



## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/yolov5_pytorch

## 参考

[GitHub - ultralytics/yolov5 at v6.0](https://github.com/ultralytics/yolov5/tree/v6.0)


