# DLIB

## 环境配置

使用DCU编译之前，需要准备编译环境。参考
[environment prepare](environment_prepare.md)

## 使用源码安装

### 编译环境准备（以dtk-23.04版本为例）

- 拉取代码

  ```
  git clone -b develop http://developer.hpccube.com/codes/aicomponent/warpctc.git
  ```
- 在[开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-23.04 解压至 /opt/ 路径下，并建立软链接

  ```
  cd /opt && ln -s dtk-23.04 dtk
  ```

- 导入环境变量以及安装必要依赖库

  ```shell
  source /opt/dtk/env.sh
  ```

### 编译安装

#### 编译 Python API

- 使用python安装

```shell
cd pytorch_binding
python setup.py install
```

- 使用python编译whl包

```shell
cd pytorch_binding
python setup.py bdist_wheel
```

### 测试

- 验证warpctc的loss正确性（CPU和GPU的一致性）

```shell
cd pytorch_binding/tests
python3 test_gpu.py
```

- 验证warpctc的loss的GPU加速效果

```shell
cd pytorch_binding/tests
python3 test_gpu_speed.py
```
 



