# <div align="center"><strong>torchvision</strong></div>
## 简介
torchvision 软件包由常用的数据集、模型架构和计算机视觉的常见图像转换组成。

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |vision版本   | DTK版本                  | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ----------- | ------------------------ | -----------------| ------------ |
   | 2.5.1       | 2.1.0       |v0.19.1      | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |v0.19.1      | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他        | 其他                     | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
vision whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/vision)，选择对应的pytorch版本和python版本下载对应vision的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torchvision* (下载的vision-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 相关依赖问题
可通过conda或源码编译安装libpng/libjpeg
```shell
  conda install libpng
  conda install jpeg
```
libpng和libjpeg必须在编译时可用，确保它在标准库位置可用，否则，分别在环境变量TORCHVISION_INCLUDE和TORCHVISION_LIBRARY中添加头文件路径和库路径。
```shell
  pip3 install pybind11 
  pip3 install 'numpy<=1.24.3' 
  pip3 install 'urllib3==1.26.14' 
  pip3 install requests 
  pip3 install wheel 
```

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
```

#### 源码编译安装
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/vision.git # 根据编译需要切换分支
```

- 提供源码编译方式（进入vision目录）：
```shell
1. 设置不转码编译环境变量
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C
```
2. 编译whl包并安装
```shell
python3 setup.py -v bdist_wheel
pip install dist/torchvision*
```
3. 源码编译安装
```shell
python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证

- python -c "import torchvision; torchvision.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如v0.19.1；

## Known issue
- 无

## 参考资料
- [README_ORIGIN.md](README_ORIGIN.md)
- [https://github.com/pytorch/vision.git](https://github.com/pytorch/vision.git)
