# Changelog

All notable changes to this project will be documented in this file. See [conventional commits](https://www.conventionalcommits.org/) for commit guidelines.

---
## [0.1.3] - 2024-04-26

### Bug Fixes

- **(load)** set cuda device in each thread
- **(security)** fix typo in comments
- **(ut)** clean files in ut
- directIO segmentation fault
- modify aksk less real

### Features

- **(security)** compat with cipher header and use cipher in posix
- **(sfcs)** set sfcs sync interval by environ
- **(sfcs)** reduce memcpy
- **(sfcs)** parse sfcs confs from environ in json format
- add clone mode for shared tensor
- get cfs task id from env

### Miscellaneous Chores

- **(security)** clarify cipher readme
- cpp coding style

### License

- add license file and header

## [0.1.2] - 2024-01-25

### Bug Fixes

- **(saver)** add return to remove repetitive writing 
- **(security)** socket path and ut bug 
- MANIFEST does not contain all fastcrypto lib files 

### Documentation

- update readme 

### Features

- **(security)** fetch key and iv 
- **(security)** get and refresh sfcs aksk from datapipe 
- **(security)** get namenode ip from datapipe and fix write xml bug 
- **(sfcs)** decide load use sfcs sdk from environ 

## [0.1.1] - 2023-11-17

### Bug Fixes

- **(sfcs)** keep in consistent with reading when open for writing 
- **(ut)** delete potential residual test file before testing 
- fix ci release and update readme for pip install 

### Documentation

- use index-url as default install method 

### Features

- **(ci)** add import format tool in ci 
- **(saver)** introduce saver class to aggregate save operations 
- **(security)** add cipher in sfcs sdk 
- **(sfcs)** load and save pt 
- load pt file in parallel from sfcs 

### Miscellaneous Chores

- bump version to v0.1.0 
- bump version to v0.1.1 

### Performance

- make the read usage with good alignment. 

<!-- generated by git-cliff -->
