import importlib.util


def _check_module_exists(name: str) -> bool:
    r"""Returns if a top-level module with :attr:`name` exists *without**
    importing it. This is generally safer than try-catch block around a
    `import X`. It avoids third party libraries breaking assumptions of some of
    our tests, e.g., setting multiprocessing start method when imported
    (see librosa/#747, torchvision/#544).
    """
    spec = importlib.util.find_spec(name)
    return spec is not None

IMPORT_NUMPY = _check_module_exists('numpy')
IMPORT_KALDI_IO = _check_module_exists('kaldi_io')
IMPORT_SCIPY = _check_module_exists('scipy')
IMPORT_LIBROSA = _check_module_exists('librosa')
