# <div align="center"><strong>TorchAudio</strong></div>
## 简介
torchaudio 的目标是将 PyTorch 应用于音频领域。通过支持 PyTorch，torchaudio 遵循了相同的理念，即提供强大的 DCU 加速，注重通过 autograd 系统实现可训练的特性，并保持一致的风格（张量命名和维度命名）。因此，它主要是一个机器学习库，而不是一个通用的信号处理库。PyTorch 的优势在 torchaudio 中得以体现，所有计算都通过 PyTorch 操作完成，这使得它易于使用，并且像 PyTorch 的自然扩展。
## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |audio版本      | DTK版本                  | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ----------- | ------------------------ | -----------------| ------------ |
   | 2.5.1       | 2.1.0       |2.5.1        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |2.4.1        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他         | 其他        | 其他                     | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
audio whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main)，选择对应的pytorch版本和python版本下载对应audio的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install audio* (下载的audio-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
pip install setuptools==59.5.0 wheel
```

#### 源码编译安装
源码编译安装要求cmake版本不要过高，推荐版本cmake3.19.0
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/torchaudio.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入torchaudio目录）：
```
1. 设置不转码编译环境变量
source /usr/local/bin/fastpt -C

2. 编译whl包并安装
python3 setup.py -v bdist_wheel
pip install dist/audio*

3. 源码编译安装
python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk
+ 在pytorch2.5.1环境下编译需要支持c++17语法，打开setup.py文件，把文件中的 -std=c++14 修改为 -std=c++17

## 验证
- python -c "import torchaudio; print(torchaudio.__version__)"，版本号与官方版本同步，查询该软件的版本号，例如2.5.1；

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [README_zh-CN](README_zh-CN.md)
- [https://github.com/pytorch/audio](https://github.com/pytorch/audio)
