# <div align="center"><strong>TorchAudio</strong></div>

## 简介

torchaudio 的目标是将 PyTorch 应用于音频领域。通过支持 PyTorch，torchaudio 遵循了相同的理念，即提供强大的 DCU 加速，注重通过 autograd 系统实现可训练的特性，并保持一致的风格（张量命名和维度命名）。因此，它主要是一个机器学习库，而不是一个通用的信号处理库。PyTorch 的优势在 torchaudio 中得以体现，所有计算都通过 PyTorch 操作完成，这使得它易于使用，并且像 PyTorch 的自然扩展。torchaudio官方github地址:[GitHub - pytorch/audio: Data manipulation and transformation for audio signal processing, powered by PyTorch](https://github.com/pytorch/audio)

- 支持音频输入输出（加载文件，保存文件）
  
  - 使用 SoX 将各种音频格式（如 wav、mp3、ogg、flac、opus、sphere）加载到 PyTorch 的张量中。  
  
  - 支持 Kaldi（ark/scp）格式。

- 数据加载器
  
  - 提供常见音频数据集的数据加载器。  

- 音频与语音处理功能
  
  - 强制对齐（forced_align）。  

- 常用音频变换
  
  - 提供如频谱图、AmplitudeToDB、MelScale、MelSpectrogram、MFCC、MuLaw 编码与解码、重采样等常用的音频变换。  

- 兼容性接口
  
  - 通过 PyTorch 运行与其他库（如 Kaldi）对齐的代码，包括频谱图、fbank、MFCC 等功能。

## 安装

### 适用环境

- ubuntu20.04 或 rocky8.6

- Python==3.10

- PyTorch==2.4.1 DTK=25.04

### 使用pip方式安装
```shell
pip install torchaudio* # (请下载对应操作系统的torchaudio的whl包)
```

### 源码编译安装

#### 编译环境准备

- 拉取torchaudio代码

```shell
git clone -b 2.4.1-dtk2504 http://developer.hpccube.com/codes/OpenDAS/torchaudio.git
```

- 导入环境变量以及安装必要依赖库

```shell
source /opt/dtk/env.sh
```

#### 编译安装

- 执行编译命令并安装

```shell
bash install.sh
cd ..
pip install dist/torchaudio*
```

## 版本号查询

```shell
python -c "import torchaudio; print(torchaudio.__version__)"
```

- 版本号与官方版本同步，查询该软件的版本号，例如2.4.1；

## Known Issue

- 无 

## 其他参考

- [README_ORIGIN](README_ORIGIN.md)

- [GitHub - pytorch/audio](https://github.com/pytorch/audio)
