#!/bin/bash

pip install kaldi_io -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install SoundFile -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install numpy==1.24.3 -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple

set -e

source /opt/dtk/env.sh
source /usr/local/bin/fastpt -C

echo "开始编译组件torchaudio"
python3 setup.py -v bdist_wheel
echo "组件torchaudio 编译完成"

ls dist/
pip install dist/torchaudio*.whl --force-reinstall --no-deps
echo "组件torchaudio安装完成"

echo "开始torchaudio单元测试"
if command -v pytest &> /dev/null; then
    echo "pytest 已安装，版本: $(pytest --version)"
    # 跳过安装
else
    echo "pytest 未安装，正在安装..."
    # 使用 pip 安装 (最常见)
    pip install pytest
fi

pytest -vs ./test
