#!/bin/bash

pip install -r test_requirements.txt

set -e

source /opt/dtk/env.sh
source /usr/local/bin/fastpt -C

echo "开始编译组件torchani"
python3 setup.py -v bdist_wheel --cuaev
echo "组件torchani编译完成"

ls dist/
pip install dist/torchani*.whl
pip install dist/torchani*.whl --force-reinstall --no-deps

echo "组件torchani安装完成"


echo "开始torchani单元测试"
if command -v pytest &> /dev/null; then
    echo "pytest 已安装，版本: $(pytest --version)"
    # 跳过安装
else
    echo "pytest 未安装，正在安装..."
    # 使用 pip 安装 (最常见)
    pip install pytest
fi

pytest -vs ./tests

