# <div align="center"><strong>Torchani</strong></div>
## 简介
torchani 是一个基于 PyTorch 的神经网络势能（ANI）的开源实现。ANI 是一种利用深度学习模型来预测分子间相互作用力的方法，广泛应用于分子动力学模拟、化学反应路径探索等领域。torchani 的设计目标是提供一种高效、易于使用且高度可扩展的神经网络势能计算工具。
## 安装
  源码编译安装，该方式需要安装torch及fastpt工具包；注意使用fastpt包进行源码编译安装时，要严格匹配fastpt、torch、dtk之间的版本号，例如基于dtk2504编译，则fastpt、torch都必须是dtk2504的包，其中fastpt与torch对应的版本号关系为
|   | fastpt版本 | torch版本    | DTK版本 | 
| - | -------- | ------- | ------------ | 
| 1 | 2.0.1+das.dtk2504   | v2.4.1 |  dtk2504| 
| 1 | 2.1.0+das.dtk2504   | v2.5.1 |  dtk2504| 
| 1 | 2.0.1+das.dtk25041   | v2.4.1 |  dtk25041| 
| 1 | 2.1.0+das.dtk25041   | v2.5.1 |  dtk25041| 

## 编译流程
  ```
  pip3 install pytest
  pip3 install wheel
  pip3 isntall ase
  pip3 install fastpt-2.0.1+das.dtk2504-py3-none-any.whl #以torch2.4.1，dtk2504为例
  git clone https://developer.sourcefind.cn/codes/OpenDAS/torchani.git
  cd torchani
  git checkout * #切换到相应分支
  source  /usr/local/bin/fastpt -c
  python3 setup.py bdist_wheel --cuaev# 该指令用于编译whl包，执行该指令时不必执行前两个指令
  ```
## 验证安装
```
pip3 list | grep torchani
python3
import torchani 
torchani.__version__
#返回版本号
```
## 测试
执行测试前需要执行download.sh脚本下载所需数据
```
source  /usr/local/bin/fastpt -e
cd tests
pytest vs

```
