# <div align="center"><strong>Torchani</strong></div>
## 简介
torchani 是一个基于 PyTorch 的神经网络势能（ANI）的开源实现。ANI 是一种利用深度学习模型来预测分子间相互作用力的方法，广泛应用于分子动力学模拟、化学反应路径探索等领域。torchani 的设计目标是提供一种高效、易于使用且高度可扩展的神经网络势能计算工具。

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |torchani版本      | DTK版本                  | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ----------- | ------------------------ | -----------------| ------------ |
   | 2.5.1       | 2.1.0       |0.1        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |0.1        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   
+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
torchani whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/)，选择对应的pytorch版本和python版本下载对应torchani的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torchani* (下载的torchani-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip3 install pytest
pip3 install wheel
pip3 isntall ase
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
pip install setuptools==59.5.0 wheel
```

#### 源码编译安装
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/torchani.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入torchani目录）：
```
1. 设置不转码编译环境变量
source /usr/local/bin/fastpt -C

2. 编译whl包并安装
python3 setup.py -v bdist_wheel --cuaev
pip install dist/torchani*

3. 源码编译安装
python3 setup.py install --cuaev
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk
+ 在pytorch2.5.1环境下编译需要支持c++17语法，打开setup.py文件，把文件中的 -std=c++14 修改为 -std=c++17

## 验证
```
 python3
Python 3.10.12 (main, Feb  4 2025, 14:57:36) [GCC 11.4.0] on linux
Type "help", "copyright", "credits" or "license" for more information.
>>> import torchani
>>> torchani.__version__
'0.1*'
>>>
```
版本号与官方版本同步，查询该软件的版本号，例如0.1*；

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [README_zh-CN](README_zh-CN.md)
- [https://github.com/aiqm/torchani](https://github.com/aiqm/torchani)
