# <div aligh="center"><strong>PyTorch Spline Conv</strong></div>
## 简介
Pytorch Spline Conv 是基于PyTorch框架的一个软件包，用于实现图卷积神经网络中的Spline卷积操作。图卷积神经网络是一种能够在图结构数据上进行深度学习的模型，适用于节点分类、图分类和图生成等任务。DAS软件栈中的PyTorch Spline Conv 版本,不仅保证了该组件 核心功能在DCU加速卡的可用性，还针对DCU特有的硬件架构进行了深度定制优化，这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前已适配支持Pytorch1.13，Pyotrch2.1，Pytorch2.4.1. Pytorch2.5.1

### 使用pip方式安装
pytorch-spline-conv whl包下载目录：[https://das.sourcefind.cn:55011/portal/#/home](https://das.sourcefind.cn:55011/portal/#/home). 
```shell
pip install torch_spline_conv* (下载的torch_spine_conv的whl包)
```
### 使用源码编译方式安装

#### 编译环境准备
- 安装相关依赖
```shell
pip install numpy
pip install 'urllib3==1.26.14'
pip install pytest
pip insta;; wheel
```
- 在首页 | 光合开发者社区下载 dtk25.04 解压在 /opt/ 路径下，并建立软连接，例如
```shell
cd /opt & ln -s dtk-25.04 dtk

```

- 安装pytorch. pytorch whl包下载目录: [https://das.sourcefind.cn:55011/portal/#/home](https://das.sourcefind.cn:55011/portal/#/home). 根据需求下载对应的版本，安装如下：
```shell
pip install torch* (下载的torch的whl包)
```

- 安装fastpt. fastpt whl包下载目录: [https://das.sourcefind.cn:55011/portal/#/home](https://das.sourcefind.cn:55011/portal/#/home). 根据需求下载对应的版本，安装如下：
```shell
pip install fastpt* (下载的fastpt whl包)
```


#### 源码下载编译安装
```shell
git clone -b 1.2.2-fastpt http://developer.hpccube.com/codes/aicomponent/torch-spline-conv.git
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C
cd torch-spline-conv
python setup.py bdist_wheel
pip install dist/*.whl
```

## 单侧
```shell
cd torch-spline-conv
python setup.py test
pytest
```

## Known Issue
完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。
```
find / -name "_version_cpu.so"
cd /torch_spline_conv/torch_spline_conv
ln -s /usr/local/lib/python3.8/site-packages/torch_spline_conv/* .
```
## 参考资料
[https://github.com/rusty1s/pytorch_spline_conv](https://github.com/rusty1s/pytorch_spline_conv)
