from os import path as osp

from setuptools import setup, find_packages

__version__ = '0.1.0'
url = 'https://github.com/rusty1s/pytorch_spline_conv'

install_requires = ['cffi', 'torch-unique']
setup_requires = ['pytest-runner', 'cffi']
tests_require = ['pytest', 'pytest-cov']

setup(
    name='torch_spline_conv',
    version=__version__,
    description='PyTorch Implementation of the Spline-Based Convolution'
    'Operator of SplineCNN',
    author='Matthias Fey',
    author_email='matthias.fey@tu-dortmund.de',
    url=url,
    download_url='{}/archive/{}.tar.gz'.format(url, __version__),
    keywords=[
        'pytorch', 'cnn', 'spline-cnn', 'geometric-deep-learning', 'graph',
        'mesh'
    ],
    install_requires=install_requires,
    setup_requires=setup_requires,
    tests_require=tests_require,
    packages=find_packages(exclude=['build']),
    ext_package='',
    cffi_modules=[osp.join(osp.dirname(__file__), 'build.py:ffi')],
)
