# <div aligh="center"><strong>PyTorch Spline Conv</strong></div>
## 简介
Pytorch Spline Conv 是基于PyTorch框架的一个软件包，用于实现图卷积神经网络中的Spline卷积操作。图卷积神经网络是一种能够在图结构数据上进行深度学习的模型，适用于节点分类、图分类和图生成等任务。DAS软件栈中的PyTorch Spline Conv 版本,不仅保证了该组件 核心功能在DCU加速卡的可用性，还针对DCU特有的硬件架构进行了深度定制优化，这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前已适配支持Pytorch1.13，Pyotrch2.1，Pytorch2.4.1. Pytorch2.5.1

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |pytorch_Spline_Conv版本   | DTK版本      | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ------------------------ | ------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |1.2.2                     | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |1.2.2                     | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他                     | 其他         | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

- 安装相关依赖
```shell
pip install 'urllib3==1.26.14'
pip install pytest
pip install numpy
pip install wheel
```
### 1、使用pip方式安装
torch_spline_conv whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/torch_spline_conv)，选择对应的pytorch版本和python版本下载对应torch_spline_conv的whl包

```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torch_spline_conv* (下载的torch_spline_conv-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
```
#### 源码下载编译安装
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/torch-spline-conv.git  # 根据编译需要切换分支
```

- 提供2种源码编译方式（进入torch-spline-conv目录）：
1. 设置不转码编译环境变量
```shell
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C
```

2. 编译whl包并安装
```shell
cd torch-spline-conv
python setup.py bdist_wheel
pip install dist/*.whl
```

3. 源码编译安装
```shell
python3 setup.py install
```

#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
python -c "import torch_spline_conv; torch_spline_conv.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如1.2.2

## 单侧
```shell
cd torch-spline-conv
python setup.py test
pytest
```

## Known Issue
完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。
```
find / -name "_version_cpu.so"
cd /torch_spline_conv/torch_spline_conv
ln -s /usr/local/lib/python3.8/site-packages/torch_spline_conv/* .
```
## 参考资料
[https://github.com/rusty1s/pytorch_spline_conv](https://github.com/rusty1s/pytorch_spline_conv)
