#include <Python.h>
#include <torch/script.h>

#ifdef WITH_HIP
#include <hip/hip_runtime.h>
#endif

#ifdef _WIN32
#ifdef WITH_HIP
PyMODINIT_FUNC PyInit__version_cuda(void) { return NULL; }
#else
PyMODINIT_FUNC PyInit__version_cpu(void) { return NULL; }
#endif
#endif

int64_t cuda_version() {
#ifdef WITH_HIP
  return TORCH_HIP_VERSION;
#else
  return -1;
#endif
}

static auto registry = torch::RegisterOperators().op(
    "torch_spline_conv::cuda_version", &cuda_version);
