# <div aligh="center"><strong>PyTorch Sparse</strong></div>
## 简介
Pytorch Sparce 是 个包包含了一个小型扩展库，用于优化支持自动微分的稀疏矩阵操作。目前，这个包包括以下方法：Coalesce，Transpose，Sparse Dense Matrix Multiplication，Sparse Sparse Matrix Multiplication 所有包含的操作都支持不同类型的数据，并且既在CPU上也在GPU上实现了。DAS软件栈中的PyTorch Sparce版本，不仅保证了组件核心功能在DCU加速卡的可用性,还针对DCU特有的硬件架构进行了深度定制优化。这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前支持Pytorch1.13 Pyotrch2.1 Pytorch2.4.1 Pytorch2.5.1

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |pytorch_Sparse版本    | DTK版本      | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | -------------------- | ------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |1.6.3                 | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |1.6.3                 | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他                 | 其他         | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

- 安装相关依赖
```shell
pip install 'urllib3==1.26.14'
pip install pytest
pip install wheel
pip install numpy
```
### 1、使用pip方式安装
pytorch-sparse whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/torch_sparse)，选择对应的pytorch版本和python版本下载对应torch_sparse的whl包

```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torch_sparse* (下载的torch_sparse-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
```

#### 源码编译安装
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/torch-sparce.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入torch-sparce目录）：
1. 设置不转码编译环境变量
```shell
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C
```
2. 编译whl包并安装
```shell
cd torch-sparce
git submodule update --init --recursive  # 更新子仓
python setup.py bdist_wheel
pip install dist/*.whl
```
3. 源码编译安装
```shell
python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
python -c "import torch_sparse; torch_sparse.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如0.6.16

## 单侧
```shell
cd torch-sparce
pytest
```

## Known Issue
- 完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。
```
find / -name "_version_cpu.so"
cd /torch-sparce/torch_sparse
ln -s /usr/local/lib/python3.10/site-packages/torch_sparse/* .
```

- 编译torch_sparse==0.6.16 目前不支持torch2.1版本的torch，如果编译torch2.1版本的torch_sparse0.6.16版本需要修改一些代码,文件路径pytorch_sparse/csrc/version.cpp
```shell
static auto registry = torch::RegisterOperators().op("torch_sparse::cuda_version", &sparse::cuda_version); -> static auto registry = torch::RegisterOperators().op("torch_sparse::cuda_version", [] { return sparse::cuda_version(); });
```
代码已修改，目前已经支持torch2.1, 如果编译torch1.13 需要把上面代码修改回去.

## 参考资料
[https://github.com/rusty1s/pytorch_sparse](https://github.com/rusty1s/pytorch_sparse)
