# <div aligh="center"><strong>PyTorch Sparse</strong></div>
## 简介
Pytorch Sparce 是 SplineCNN 的基于样条的卷积算子

### 使用pip方式安装
torch-sparce whl包下载目录：[http://10.6.10.68:8000/customized/torch-sparse/dtk24.04/](http://10.6.10.68:8000/customized/torch-sparse/dtk24.04/). 目前只提供有python.10版本的安装包
```shell
pip install torch_sparse* (下载的torch_sparse的whl包)
```
### 使用源码编译方式安装

#### 编译环境准备
- 安装相关依赖
```shell
pip install numpy
pip install 'urllib3==1.26.14'
pip install pytest
pip install wheel
```
- 在首页 | 光合开发者社区下载 det24.04 解压在 /opt/ 路径下，并建立软连接，例如:
```shell
cd /opt
wget http://10.6.10.68:8000/dtk-pkg/dtk24.04/release/CentOS7.6/DTK-24.04-CentOS7.6-x86_64.tar.gz
tar -zxvf DTK-24.04-CentOS7.6-x86_64.tar.gz
ln -s dtk-24.04 dtk
source /opt/dtk/env.sh
```

- 安装pytorch. pytorch whl包下载目录: [http://10.6.10.68:8000/debug/pytorch/dtk24.04/torch-2.1.0%2Bgit1c51f6a.abi1.dtk2404-cp310-cp310-linux_x86_64.whl](http://10.6.10.68:8000/debug/pytorch/dtk24.04/torch-2.1.0%2Bgit1c51f6a.abi1.dtk2404-cp310-cp310-linux_x86_64.whl). 根据需求下载对应的版本，安装如下：
```shell
pip install torch* (下载的torch的whl包)
```
#### 源码下载编译安装
```shell
git clone -b 0.6.16-release http://developer.hpccube.com/codes/aicomponent/torch-sparce.git
cd torch-sparce
python setup.py bdist_wheel
pip install dist/*.whl
```

## 单侧
```shell
cd torch-sparce
pytest
```

## Known Issue
- 完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。
```
find / -name "_version_cpu.so"
cd /torch-sparce/torch_sparse
ln -s /usr/local/lib/python3.10/site-packages/torch_sparse/* .
```

- 编译torch_sparse==0.6.16 目前不支持torch2.1版本的torch，如果编译torch2.1版本的torch_sparse0.6.15版本需要修改一些代码,文件路径pytorch_sparse/csrc/version.cpp
```shell
static auto registry = torch::RegisterOperators().op("torch_sparse::cuda_version", &sparse::cuda_version); -> static auto registry = torch::RegisterOperators().op("torch_sparse::cuda_version", [] { return sparse::cuda_version(); });
```

## 参考资料
```shell
https://github.com/rusty1s/pytorch_sparse
```
