#!/bin/bash

set -e

source /opt/dtk/env.sh
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C

echo "开始编译组件torch-scatter "
python setup.py bdist_wheel
echo "组件torch-scatter编译完成"

ls dist/
pip install dist/*.whl --force-reinstall --no-deps

echo "组件torch-scatter安装完成"


echo "开始torch-scatter单元测试"
if command -v pytest &> /dev/null; then
    echo "pytest 已安装，版本: $(pytest --version)"
    # 跳过安装
else
    echo "pytest 未安装，正在安装..."
    # 使用 pip 安装 (最常见)
    pip install pytest
fi

pytest -vs ./test



