# <div align="center"><strong>PyTorch Scatter</strong></div>
## 简介
PyTorch Scatter由一个小型扩展库组成，该扩展库包含用于PyTorch的高度优化的稀疏更新（分散和分段）操作，这些操作在主包中丢失。分散和分段运算可以粗略地描述为基于给定“群索引”张量的归约运算。分段运算需要对“组索引”张量进行排序，而分散运算则不受这些要求的约束。PyTorch Scatter官方github地址:[https://github.com/rusty1s/pytorch_scatter](https://github.com/rusty1s/pytorch_scatter)

## 安装

### 使用pip方式安装
pytorch-scatter whl包下载目录：[http://10.6.10.68:8000/customized/torch-scatter/dtk2404](http://10.6.10.68:8000/customized/torch-scatter/dtk2404)，目前只提供有python3.8版本的whl包。
```shell
pip install torch_scatter* (下载的torch_scatter的whl包)
```
### 使用源码编译方式安装

#### 编译环境准备
- 安装相关依赖
```shell
pip install -r requirements.txt 
```
- 在首页 | 光合开发者社区下载 dtk24.04 解压至 /opt/ 路径下，并建立软链接
```shell
cd /opt && ln -s dtk-24.04 dtk
source /opt/dtk/env.sh
```
- 安装pytorch，pytorch whl包下载目录：[http://10.6.10.68:8000/debug/pytorch/dtk24.10/hipify/](http://10.6.10.68:8000/debug/pytorch/dtk24.04/hipify/)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载的torch的whl包)
```
#### 源码编译安装
```shell
git clone -b 2.1.0-release http://developer.hpccube.com/codes/aicomponent/torch-scatter.git
cd torch-scatter
python setup.py bdist_wheel
pip install dist/*.whl
```
## 单测
```shell
cd torch-scatter
python setup.py test
```
## Known Issue
完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。

```
find / -name "_version_cpu.so"
cd /torch-scatter/torch_scatter
ln -s /usr/local/lib/python3.8/site-packages/torch-scatter/* .
```

## 参考资料

https://github.com/rusty1s/pytorch_scatter
