#!/bin/bash

set -e

source /opt/dtk/env.sh
export FORCE_CUDA_EXTENSION=1
source /usr/local/bin/fastpt -C

echo "开始编译组件torch-harmonics"
python3 setup.py -v bdist_wheel
echo "组件torch-harmonics编译完成"

ls dist/
pip install dist/torch_harmonics*.whl
pip install dist/torch_harmonics*.whl --force-reinstall --no-deps

echo "组件torch-harmonics安装完成"


echo "开始torch-harmonics单元测试"
if command -v pytest &> /dev/null; then
    echo "pytest 已安装，版本: $(pytest --version)"
    # 跳过安装
else
    echo "pytest 未安装，正在安装..."
    # 使用 pip 安装 (最常见)
    pip install pytest
fi

pytest -vs ./tests

