#include <Python.h>
#include <torch/script.h>

#include "cpu/rw_cpu.h"

#ifdef WITH_HIP
#include "hip/rw_hip.h"
#endif

#ifdef _WIN32
#ifdef WITH_HIP
PyMODINIT_FUNC PyInit__rw_cuda(void) { return NULL; }
#else
PyMODINIT_FUNC PyInit__rw_cpu(void) { return NULL; }
#endif
#endif

std::tuple<torch::Tensor, torch::Tensor>
random_walk(torch::Tensor rowptr, torch::Tensor col, torch::Tensor start,
            int64_t walk_length, double p, double q) {
  if (rowptr.device().is_cuda()) {
#ifdef WITH_HIP
    return random_walk_cuda(rowptr, col, start, walk_length, p, q);
#else
    AT_ERROR("Not compiled with CUDA support");
#endif
  } else {
    return random_walk_cpu(rowptr, col, start, walk_length, p, q);
  }
}

static auto registry =
    torch::RegisterOperators().op("torch_cluster::random_walk", &random_walk);
