# <div align="center"><strong>PyTorch Cluster</strong></div>
## 简介
PyTorch Cluster是一个小型的扩展库，其中包含了高度优化的图聚类算法，用于在PyTorch中使用。该包包括以下聚类算法：Graclus，Voxel Grid Pooling，迭代最远点采样，k-NN和Radius图生成，基于最近点的聚类，随机游走采样等。DAS软件栈中的PyTorch Cluster版本，不仅保证了组件核心功能在DCU加速卡的可用性,还针对DCU特有的硬件架构进行了深度定制优化。这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前支持Pytorch1.13 Pyotrch2.1 Pytorch2.4.1 Pytorch2.5.1

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |pytorch_Cluster版本   | DTK版本      | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | -------------------- | ------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |1.6.3                 | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |1.6.3                 | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他                 | 其他         | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

- 安装相关依赖
```shell
pip install 'urllib3==1.26.14' 
pip install pytest
pip install wheel 
```
### 1、使用pip方式安装
pytorch-cluster whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/torch_cluster)，选择对应的pytorch版本和python版本下载对应torch_cluster的whl包

```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torch_cluster* (下载的torch_cluster-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
```
#### 源码编译安装
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/torch-cluster.git  # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入torch-cluster目录）：
1. 设置不转码编译环境变量
```shell
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C
```

2. 编译whl包并安装
```shell
cd pytorch_cluster || torch-cluster
python setup.py bdist_wheel
pip install dist/*.whl
```

3. 源码编译安装
```shell
python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
python -c "import torch_cluster; torch_cluster.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如1.6.3

## 单测
```shell
cd torch-cluster
pytest
```
## Known Issue
+ 完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。

```shell
find / -name "_version_cpu.so"
cd /pytorch_cluster/torch_cluster
ln -s /usr/local/lib/python3.8/site-packages/torch_cluster/* .
```

## 参考资料
[README_ORIGIN](README_ORIGIN.md)
PyTorch Cluster官方github地址:[https://github.com/rusty1s/pytorch_cluster](https://github.com/rusty1s/pytorch_cluster)
