# <div align="center"><strong>PyTorch Cluster</strong></div>
## 简介
PyTorch Cluster是一个小型的扩展库，其中包含了高度优化的图聚类算法，用于在PyTorch中使用。该包包括以下聚类算法：Graclus，Voxel Grid Pooling，迭代最远点采样，k-NN和Radius图生成，基于最近点的聚类，随机游走采样等。DAS软件栈中的PyTorch Cluster版本，不仅保证了组件核心功能在DCU加速卡的可用性,还针对DCU特有的硬件架构进行了深度定制优化。这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前支持Pytorch1.13 Pyotrch2.1 Pytorch2.4.1 Pytorch2.5.1

## 安装

### 使用pip方式安装
pytorch-cluster whl包下载目录：[https://das.sourcefind.cn:55011/portal/#/installation?id=2083b36e-6c1b-11ef-bb3e-005056904552&type=frame](https://das.sourcefind.cn:55011/portal/#/installation?id=2083b36e-6c1b-11ef-bb3e-005056904552&type=frame).
```shell
pip install torch_cluster* (下载的torch_cluster的whl包)
```
### 使用源码编译方式安装

#### 编译环境准备
- 安装相关依赖
```shell
pip install numpy
pip install 'urllib3==1.26.14' 
pip install pytest
pip install wheel 
```
- 在首页 | 光合开发者社区下载 dtk25.04 解压至 /opt/ 路径下，并建立软链接
```shell
cd /opt && ln -s dtk-25.04 dtk
source /opt/dtk/cuda/env.sh

- 安装pytorch，pytorch whl包下载目录：[http://10.16.4.1:8000/debug/pytorch/dtk25.04/](http://10.16.4.1:8000/debug/pytorch/dtk25.04/)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
pip install torch* (下载的torch的whl包)

- 安装fastpt，fastpt whl包下载目录：[https://das.sourcefind.cn:55011/portal/#/installation?id=8e0d0030-6c14-11ef-bf92-005056904552&type=frame](https://das.sourcefind.cn:55011/portal/#/installation?id=8e0d0030-6c14-11ef-bf92-005056904552&type=frame)
pip install fastpt*

```
#### 源码编译安装

```shell
git clone -b 1.6.3-fastpt http://developer.hpccube.com/codes/aicomponent/torch-cluster.git
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C

cd pytorch_cluster
python setup.py bdist_wheel
pip install dist/*.whl

```
## 单测
```shell
cd pytorch_cluster
pytest
```
## Known Issue
完成安装进行单测时，会报错ImportError: Could not find module '_version_cpu' ~，在根目录/下查找一下，然后把库文件目录添加一下软链接即可。

```
find / -name "_version_cpu.so"
cd /pytorch_cluster/torch_cluster
ln -s /usr/local/lib/python3.8/site-packages/torch_cluster/* .
```

## 参考资料

PyTorch Cluster官方github地址:[https://github.com/rusty1s/pytorch_cluster](https://github.com/rusty1s/pytorch_cluster)
