# <div align="center"><strong>PyTorch Bincount</strong></div>
## 简介
PyTorch Bincount是一个小型扩展库，该扩展库具有高度优化的 bincount作，用于 PyTorch，而主包中缺少该作。该作适用于不同的数据类型，并且同时针对 CPU 和 GPU 实现。DAS软件栈中的PyTorch Bincount版本,不仅保证了该组件 核心功能在DCU加速卡的可用性，还针对DCU特有的硬件架构进行了深度定制优化，这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前已适配支持Pytorch1.13，Pyotrch2.1，Pytorch2.4.1

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |pytorch_Bincount版本   | DTK版本      | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | -------------------- | ------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |0.1.1                 | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |0.1.1                 | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他                 | 其他         | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

- 安装相关依赖
```shell
pip install pytest
pip install wheel
```

### 使用pip方式安装
pytorch-bincount whl包下载目录：[光合开发者社区](https://download.sourcefind.cn:65024/4/main/torch_bincount)，选择对应的pytorch版本和python版本下载对应torch_bincount的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torch_bincount* (下载的torch_bincount的whl包)
```

### 使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
```
#### 源码编译安装
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/torch-bincount.git
```
- 提供2种源码编译方式（进入torch-bincount目录）：
1. 设置不转码编译环境变量
```shell
export FORCE_CUDA=1
source /usr/local/bin/fastpt -C
```

2. 编译whl包并安装
```shell
cd torch-bincount
python setup.py bdist_wheel
pip install dist/*.whl
```

3. 源码编译安装
```shell
python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
python -c "import torch_bincount; torch_bincount.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如0.1.1

## 单测
```shell
cd torch-bincount
python setup.py test
```

## Known Issue
无

## 参考资料
[README_ORIGIN.md](README_ORIGIN.md)
[https://github.com/rusty1s/pytorch_bincount.git](https://github.com/rusty1s/pytorch_bincount.git)
