# Support

Welcome to the TileLang support page! TileLang extends Apache TVM with a more accessible approach to writing high-performance GPU kernels. It currently supports CUDA targets including Ampere (sm_80+), Turing (sm_75), and Volta (sm_70) architectures. Whether you are working on common operators like GEMM and convolution or more advanced features like flash attention, TileLang aims to provide a more streamlined development experience while maintaining performance on par with hand-optimized implementations.

## How to Report Issues and Request Features

### Bug Reports and Feature Requests

We encourage you to use our GitHub Issues page to report any bugs or request new features:
	1.	Search Existing Issues: Before filing a new issue, please check if a similar one already exists.
	2.	File a New Issue: If you don’t find a matching entry, open a new issue and include as many details as possible—such as environment info, steps to reproduce, and the output logs. This will help us quickly understand and address your problem.

### Getting Help and Asking Questions

If you have questions about using TileLang, best practices, or performance tuning, there are several ways to get support:
	•	GitHub Discussions: Join the community at TileLang Discussions to ask questions, share ideas, and discuss development strategies.
	•	Stack Overflow: Use the TileLang tag when asking questions. The project maintainers and community members regularly check the tag and can offer assistance.

## Microsoft Support Policy

This project is open-source and community-driven. Primary support channels are the community forums and issue tracker mentioned above. While maintainers and contributors strive to respond promptly, we rely on community engagement to help address questions and improve the codebase.

## Contributing to TileLang

We encourage contributions from anyone interested in improving TileLang. Contributions can range from code enhancements and feature implementations to documentation improvements and bug fixes. If you’re interested in contributing, please refer to our CONTRIBUTING.md file for guidelines, including the process for signing the Contributor License Agreement (CLA), which you only need to complete once.

Your involvement helps shape TileLang’s future, ensuring it remains a versatile and high-performance tool for GPU kernel development.

This revised support page contextualizes the assistance and community channels around TileLang, while ensuring it is distinct from the original README and the previously provided content.
