 <div align="center"><strong>Text Generation Inference </strong></div>

## 简介
Text Generation Inference（TGI）是一个用 Rust 和 Python 编写的框架，用于部署和提供LLM模型的推理服务。TGI为很多大模型提供了高性能的推理服务，如LLama,Falcon,BLOOM,Baichuan,Qwen等。

## 支持模型结构列表
|     模型      | 模型并行 | FP16 |
| :----------: | :------: | :--: |
|    LLaMA          |   Yes    | Yes  |
|    LLaMA-2        |   Yes    | Yes  |
|    LLaMA-2-GPTQ        |   Yes    | Yes  |
|    LLaMA-3        |   Yes    | Yes  |
|    Codellama      |   Yes    | Yes  |
|    QWen2          |   Yes    | Yes  |
|    QWen2-GPTQ        |   Yes    | Yes  |
|    Baichuan-7B    |   Yes    | Yes  |
|    Baichuan2-7B   |   Yes    | Yes  |
|    Baichuan2-13B  |   Yes    | Yes  |


## python支持
+ Python 3.9.
+ Python 3.10.
+ DTK24.04.2

### 使用源码编译方式安装

#### 编译环境准备

有两种方式安装准备环境
##### 方式一:

### **TODO**

##### 方式二：

基于光源pytorch2.1.0基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch2.1.0、python、dtk及系统下载对应的镜像版本。pytorch2.1.0镜像里已经安装了trition,flash-attn

1. 安装Rust
```shell
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
```

2. 安装Protoc
```shell
PROTOC_ZIP=protoc-21.12-linux-x86_64.zip
curl -OL https://github.com/protocolbuffers/protobuf/releases/download/v21.12/$PROTOC_ZIP
sudo unzip -o $PROTOC_ZIP -d /usr/local bin/protoc
sudo unzip -o $PROTOC_ZIP -d /usr/local 'include/*'
rm -f $PROTOC_ZIP
```
3. 安装TGI Service
```bash
git clone http://developer.hpccube.com/codes/OpenDAS/text-generation-inference.git # 根据需要的分支进行切换
cd text-generation-inference
#安装exllama
cd server
make install-exllama #安装exllama kernels
make install-exllamav2 #安装exllmav2 kernels
cd .. #回到项目根目录
source $HOME/.cargo/env
BUILD_EXTENSIONS=True make install #安装text-generation服务
```
4. 安装benchmark
```bash
cd text-generation-inference
make install-benchmark
```
注意：若安装过程过慢，可以通过如下命令修改默认源提速。
```bash
pip config set global.index-url https://pypi.tuna.tsinghua.edu.cn/simple
```
另外，`cargo install` 太慢也可以通过在`~/.cargo/config`中添加源来提速。

## 查看安装的版本号
```bash
text-generation-launcher -V  #版本号与官方版本同步
```

## 使用前

```bash
export PYTORCH_TUNABLEOP_ENABLED=0
```

## Known Issue

- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/huggingface/text-generation-inference](https://github.com/huggingface/text-generation-inference)
