## 简介

**PyTorch3D** 是一个用于深度学习中处理**3D数据**的库。它提供了一系列功能，方便处理和操作三维数据，

## 安装

组件支持：

* Python 3.8,3.9 or 3.10

- dtk-23.10
- pytorch-2.1

### 1. pip安装

可以在光合[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取最新的  `pytorch3d` 版本，注意应与DCU Toolkit版本以及pytorch版本对应

```shell
wget http://10.6.10.68:8000/customized/pytorch3d/23.10/pytorch3d-0.7.6-cp38-cp38-linux_x86_64.whl
python -m pip install pytorch3d-0.7.6-cp38-cp38-linux_x86_64.whl
```

### 2. 源码编译安装

#### 环境准备

* 在[开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-23.10 解压至 /opt/ 路径下，并建立软链接

  ```plaintext
  cd /opt && ln -s dtk-23.10 dtk
  ```

* 在光合[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取对应的 pytorch-2.1版本（需对应 DCU Toolkit 版本）

  ```shell
  cd path/to/torch
  python3 -m pip install torch*
  ```

* 导入环境变量以及安装必要依赖库

  ```shell
  source /opt/dtk/env.sh
  pip3 install wheel -i https://pypi.tuna.tsinghua.edu.cn/simple --trusted-host pypi.tuna.tsinghua.edu.cn
  ```

#### 编译安装

* 拉取代码

  ```shell
  git clone http://developer.hpccube.com/codes/aicomponent/pytorch3d.git #注意根据需要切换分支
  ```

* 若使用 `GPU` 支持，需要设置环境变量`FORCE_CUDA`为1

  ```shell
  export FORCE_CUDA=1
  ```

- 执行编译命令

  ```shell
  cd path/to/pytorch3d
  pip install -e .
  ```

#### 注意事项

当出现错误时，参考以下说明：

* 报错提示缺少 `intel-mkl` 相关库，应安装 `intel-mkl` 或 添加库的路径到环境变量

  ```shell
  #安装
  yum-config-manager --add-repo https://yum.repos.intel.com/mkl/setup/intel-mkl.repo
  yum install intel-mkl-2020.0-088 -y --nogpgchec
  
  # 将库路径添加到环境变量中
  export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/intel/mkl/lib/intel64
  ```

* 缺少 `magma`时，安装对应库或添加环境变量

  ```shell
  # 默认dtk安装路径为 /opt/dtk
  cd /opt/dtk
  
  #安装
  wget http://10.6.10.68:8000/debug/pytorch/third_party/magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023.tar.gz
  tar -zxf magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023.tar.gz
  mv magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023 magma
  
  # 添加环境变量
  export LD_LIBRARY_PATH=${ROCM_PATH}/magma/lib:$LD_LIBRARY_PATH
  ```

## 验证

* python -c "import pytorch3d; pytorch3d.\_\_version__"，版本号与官方版本同步，查询该软件的版本号。



