#!/bin/bash

pip install pandas -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install lpips -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install plotly -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install visdom -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install sqlalchemy -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install pycuda -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple
pip install PyOpenGL PyOpenGL_accelerate -i https://mirrors.huaweicloud.com/artifactory/pypi-public/simple

set -e

source /opt/dtk/env.sh
source /usr/local/bin/fastpt -C

echo "开始编译组件pytorch3d"
export FORCE_CUDA=1
pip install -e .
python3 setup.py -v bdist_wheel
echo "组件pytorch3d 编译完成"

ls dist/
pip install dist/pytorch3d*.whl
pip install dist/pytorch3d*.whl --force-reinstall --no-deps
echo "组件pytorch3d安装完成"

echo "开始pytorch3d单元测试"
if command -v pytest &> /dev/null; then
    echo "pytest 已安装，版本: $(pytest --version)"
    # 跳过安装
else
    echo "pytest 未安装，正在安装..."
    # 使用 pip 安装 (最常见)
    pip install pytest
fi

pytest -vs ./tests

