## 简介

**PyTorch3D** 是一个用于深度学习中处理**3D数据**的库。它提供了一系列功能，方便处理和操作三维数据。详细内容请查看[README_ORIGIN.md](README_ORIGIN.md)。

## 安装

组件支持：

* Python 3.8,3.9 or 3.10
- dtk-24.04
- pytorch-2.1

### 1. pip安装

可以在[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取  `pytorch3d` 安装包，注意dtk以及pytorch版本对应。

```shell
python -m pip install pytorch3d*.whl
```

### 2. 源码编译安装

#### 环境准备
若未安装dtk、torch，可参考以下安装

* 在[光合开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-24.04解压至 /opt/ 路径下，并建立软链接

  ```plaintext
  cd /opt && ln -s dtk-24.4 dtk
  ```

* 在[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取对应的 pytorch-2.1版本（需对应 DCU Toolkit 版本）

  ```shell
  cd path/to/torch
  python3 -m pip install torch*
  ```

* 导入环境变量以及安装必要依赖库

  ```shell
  source /opt/dtk/env.sh
  pip3 install wheel -i https://pypi.tuna.tsinghua.edu.cn/simple --trusted-host pypi.tuna.tsinghua.edu.cn
  ```

#### 编译安装


* 若使用 `GPU` 支持，需要设置环境变量`FORCE_CUDA`为1

  ```shell
  export FORCE_CUDA=1
  # DCU环境下添加以下环境变量
  export HIPCC_COMPILE_FLAGS_APPEND="--gpu-max-threads-per-block=1024"
  ```

- 执行编译命令

  ```shell
  cd path/to/pytorch3d
  pip install -e .
  ```

#### 注意事项

当出现错误时，参考以下说明：

* 报错提示缺少 `intel-mkl` 相关库，应安装 `intel-mkl` 或 添加库的路径到环境变量

  ```shell
  #安装
  yum-config-manager --add-repo https://yum.repos.intel.com/mkl/setup/intel-mkl.repo
  yum install intel-mkl-2020.0-088 -y --nogpgchec
  
  # 将库路径添加到环境变量中
  export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/intel/mkl/lib/intel64
  ```

* 缺少 `magma`时，安装对应库或添加环境变量

  ```shell
  # 默认dtk安装路径为 /opt/dtk
  cd /opt/dtk
  
  #安装
  wget http://10.6.10.68:8000/debug/pytorch/third_party/magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023.tar.gz
  tar -zxf magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023.tar.gz
  mv magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023 magma
  
  # 添加环境变量
  export LD_LIBRARY_PATH=${ROCM_PATH}/magma/lib:$LD_LIBRARY_PATH
  ```

## 验证

* `python -c "import pytorch3d; print(pytorch3d.__version__)"`，版本号与官方版本同步，查询该软件的版本号。



