# <div align="center"><strong>Pytorch3d</strong></div>

## 1 简介

PyTorch3D 为基于 PyTorch 的 3D 计算机视觉研究提供了高效、可复用的组件。
主要功能包括：

* 用于存储和操作三角网格的数据结构
* 高效的三角网格操作（投影变换、图卷积、采样、损失函数等）
* 可微分网格渲染器

PyTorch3D 专为与深度学习方法无缝集成而设计，可用于预测和处理 3D 数据。因此，PyTorch3D 的所有算子均具备以下特性：

* 基于 PyTorch 张量实现
* 支持异构数据的批量处理
* 可微分计算
* 支持 GPU 加速

## 2 安装

组件支持组合

| PyTorch版本 | fastpt版本 | cuBVH版本     | DTK版本  | Python版本      | 推荐编译方式 |
| ----------- | ---------- | ------------- | -------- | --------------- | ------------ |
| 2.5.1       | 2.1.0      | main-eeb9d5fa | >= 25.04 | 3.8、3.10、3.11 | fastpt不转码 |
| 2.4.1       | 2.0.1      | main-eeb9d5fa | >= 25.04 | 3.8、3.10、3.11 | fastpt不转码 |

+ pytorch 版本大于 2.4.1 && dtk 版本大于 25.04 推荐使用 fastpt 不转码编译。

### 2.1 使用pip方式安装

pytorch3d whl 包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main)，选择对应的 pytorch 版本和 python 版本下载对应 pytorch3d 的 whl 包: 

```shell
pip install torch* # 下载torch的whl包
pip install fastpt* --no-deps # 下载fastpt的whl包
source  /usr/local/bin/fastpt -E
pip install pytorch3d* # # 下载的 pytorch3d-fastpt 的whl包
```

### 2.2 使用源码编译方式安装

#### 2.2.1 编译环境准备

提供基于 fastpt 不转码编译：

1. 基于光源 pytorch 基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据 pytorch、python、dtk 及系统下载对应的镜像版本。
2. 基于现有 python 环境：安装 pytorch，fastpt whl 包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据 python、dtk 版本，下载对应 pytorch 的 whl 包。安装命令如下：

```shell
pip install torch* # 下载torch的whl包
pip install fastpt* --no-deps # 下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt
pip install setuptools==59.5.0 wheel pytest
```

#### 2.2.2 源码编译安装

- 代码下载

```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/pytorch3d.git # 根据编译需要切换分支
```

- 提供2种源码编译方式（进入 pytorch3d 目录）：
  - 源码编译安装：

    ```bash
    source /usr/local/bin/fastpt -C

    export FORCE_CUDA=1 # 编译 cuda 版本

    python setup.py develop
    python setup.py install
    ```
  - whl 包构建安装：

    ```bash
    source /usr/local/bin/fastpt -C
    export FORCE_CUDA=1 # 编译 cuda 版本
    python setup.py bdist_wheel # 该指令用于编译 whl 包
    pip install dist/pytorch3d-0.7.8-cp310-cp310-linux_x86_64.whl
    ```

#### 2.2.3 注意事项

+ ROCM_PATH 为 dtk 的路径，默认为 /opt/dtk；
+ 在 pytorch2.5.1 环境下编译需要支持 c++17 语法，打开setup.py文件，把文件中的 -std=c++14 修改为 -std=c++17。

## 3 验证
- 执行下面的命令获取版本号：
```bash
source /usr/local/bin/fastpt -E

python
>>> import pytorch3d
>>> pytorch3d.__version__
'0.7.8'
```

- 执行下面的命令测试组件：

```bash
pip install omegaconf
pip install tabulate
pip install pyopengl
pip install pycuda
pip install visdom
pip install lpips
pip install plotly

source /usr/local/bin/fastpt -E

export PYTORCH3D_NO_TEST_OPENGL=1 # skip OpenGL 相关测试用例
pytest -vs ./tests
```

## 4 Known Issue

- 无

## 5 参考资料

- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/facebookresearch/pytorch3d.git](https://github.com/facebookresearch/pytorch3d.git)
