<h1 align="center">PyGAS: Auto-Scaling GNNs in PyG</h1>

## 简介
PyGAS是我们提出的GNNAutoScale（GAS）框架的实践实现，该框架能够将任意消息传递图神经网络（GNN）扩展到大规模图数据上。GAS通过利用历史训练迭代中存储的嵌入向量，对计算图的整个子树进行剪枝，从而实现了以下两大突破：

- 恒定GPU显存消耗：使显存占用与输入小批量大小无关
- 最大化模型表达能力：保留完整的拓扑信息而无须牺牲模型性能

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |PyGAS版本      | DTK版本                  | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ----------- | ------------------------ | -----------------| ------------ |
   | 2.5.1       | 2.1.0       |master-be65e92        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |master-be65e92        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他         | 其他        | 其他                     | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
PyGAS whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main)，选择对应的pytorch版本和python版本下载对应PyGAS的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install torch_geometric_autoscale* (下载的PyGAS的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
pip install pytest
pip install wheel
```

#### 源码编译安装
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/pyg_autoscale.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入pyg_autoscale目录）：
```
1. 设置不转码编译环境变量
source /usr/local/bin/fastpt -C

2. 编译whl包并安装
python3 setup.py -v bdist_wheel
pip install dist/torch_geometric_autoscale* --no-deps

3. 源码编译安装
export FORCE_CUDA=1
python3 setup.py install --no-deps
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk
+ 在pytorch2.5.1环境下编译需要支持c++17语法，打开setup.py文件，把文件中的 -std=c++14 修改为 -std=c++17

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/rusty1s/pyg_autoscale.git](https://github.com/rusty1s/pyg_autoscale.git)
