#pip install transformers==4.38.0
ENV=dsw                          # 运行环境配置开关: dsw单机训练训练，dlc表示多机训练环境
MODEL_SIZE=7B                   # 模型结构参数量级: 2B/7B/72B
BATCH_SIZE=1                   # 一次迭代一个数据并行内的样本数
GLOBAL_BATCH_SIZE=256            # 一次迭代多个数据并行的总样本数
LR=0.00015                           # 学习率
MIN_LR=1e-5                       # 最小学习率
SEQ_LEN=1024                      # 序列长度
PAD_LEN=1024                     # Padding后长度
PR=fp16                         # 训练精度: fp16, bf16, fp8
TP=2                        # 模型并行度
PP=1                        # 流水并行度
CP=1                        # 上下文并行度
DO=false                        # 是否使用Megatron版Zero-1降显存优化器: true, false
FL=true                       # 是否优先使用Flash Attention: true, false
AC=false                        # 激活检查点模式: sel, full, offload, false
OPTIMIZER_OFFLOAD=false         # 是否启用Offload optimizer: false, static, auto
SAVE_INTERVAL=100000             # 保存ckpt的间隔
DATASET_PATH=/public/new-pai/data/llava-datasets/wds              # 训练数据集路径
VALID_DATASET_PATH=/public/new-pai/data/llava-datasets/wds       # 验证数据集路径
# PRETRAIN_CHECKPOINT_PATH=./Qwen2-VL-7B-Instruct-tp2pp2  # 预训练模型路径
PRETRAIN_CHECKPOINT_PATH=/public/new-pai/model/Qwen2-VL-7B-Instruct/
TRAIN_ITERS=20000               # Iter数
LR_WARMUP_ITERS=200           # 预热Iter数        
OUTPUT_BASEPATH=./output_mcore_qwen2vl_pretrain           # 训练输出日志文件路径

sh run_mcore_qwen-dcu.sh  \
    $ENV  \
    $MODEL_SIZE   \
    $BATCH_SIZE    \
    $GLOBAL_BATCH_SIZE \
    $LR   \
    $MIN_LR   \
    $SEQ_LEN  \
    $PAD_LEN  \
    $PR  \
    $TP   \
    $PP  \
    $CP \
    $DO \
    $FL   \
    $AC \
    $OPTIMIZER_OFFLOAD \
    $SAVE_INTERVAL  \
    $DATASET_PATH   \
    $VALID_DATASET_PATH   \
    $PRETRAIN_CHECKPOINT_PATH   \
    $TRAIN_ITERS  \
    $LR_WARMUP_ITERS   \
    $OUTPUT_BASEPATH