

ENV=dsw                         # 运行环境配置开关: dsw单机训练训练，dlc表示多机训练环境
MODEL_SIZE=0.5B                 # 模型结构参数量级: 0.5B/1.5B/3B/7B/14B/32B/72B
BATCH_SIZE=1                    # 一次迭代一个数据并行内的样本数
GLOBAL_BATCH_SIZE=4             # 一次迭代多个数据并行的总样本数
LR=1e-5                         # 学习率
MIN_LR=1e-6                     # 最小学习率
SEQ_LEN=128                     # 序列长度
PAD_LEN=128                     # Padding长度
PR=fp16                         # 训练精度: fp16, bf16, fp8
TP=1                            # 模型并行度
PP=2                            # 流水并行度
CP=1                            # 上下文并行度
SP=true                         # 是否使用序列并行: true, false
DO=true                         # 是否使用Megatron版Zero-1降显存优化器: true, false
FL=true                         # 是否优先使用Flash Attention: true, false
SFT=false                       # 是否执行微调训练: true, false
AC=sel                          # 激活检查点模式: sel, full, offload, false
OPTIMIZER_OFFLOAD=false         # 是否启用Offload optimizer: false, static, auto
SAVE_INTERVAL=10000             # 保存ckpt的间隔
DATASET_PATH=/public/new-pai/data/qwen-datasets/wudao_qwenbpe_text_document              # 训练数据集路径
VALID_DATASET_PATH=/public/new-pai/data/qwen-datasets/wudao_qwenbpe_text_document        # 验证数据集路径 
PRETRAIN_CHECKPOINT_PATH=/public/new-pai/model/Qwen2.5-0.5B                              # 预训练模型路径
# PRETRAIN_CHECKPOINT_PATH=/public/new-pai/Pai-Megatron-Patch/examples/qwen2_5/Qwen2.5-0.5B-hf-to-mcore-te-tp2-pp1
TRAIN_TOKENS_OR_ITERS=100000    # 训练TOKEN或者Iter数
WARMUP_TOKENS_OR_ITERS=1000     # 预热TOKEN或者Iter数        
OUTPUT_BASEPATH=./output        # 训练输出日志文件路径

bash run_mcore_qwen-dcu.sh  \
    $ENV  \
    $MODEL_SIZE   \
    $BATCH_SIZE    \
    $GLOBAL_BATCH_SIZE \
    $LR   \
    $MIN_LR   \
    $SEQ_LEN  \
    $PAD_LEN  \
    $PR  \
    $TP   \
    $PP  \
    $CP \
    $SP \
    $DO   \
    $FL \
    $SFT \
    $AC   \
    $OPTIMIZER_OFFLOAD \
    $SAVE_INTERVAL  \
    $DATASET_PATH   \
    $VALID_DATASET_PATH   \
    $PRETRAIN_CHECKPOINT_PATH  \
    $TRAIN_TOKENS_OR_ITERS  \
    $WARMUP_TOKENS_OR_ITERS   \
    $OUTPUT_BASEPATH
